/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STDocumentationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.BallerinaNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STBallerinaNameReferenceNode
extends STDocumentationNode {
    public final STNode referenceType;
    public final STNode startBacktick;
    public final STNode nameReference;
    public final STNode endBacktick;

    STBallerinaNameReferenceNode(STNode referenceType, STNode startBacktick, STNode nameReference, STNode endBacktick) {
        this(referenceType, startBacktick, nameReference, endBacktick, Collections.emptyList());
    }

    STBallerinaNameReferenceNode(STNode referenceType, STNode startBacktick, STNode nameReference, STNode endBacktick, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.BALLERINA_NAME_REFERENCE, diagnostics);
        this.referenceType = referenceType;
        this.startBacktick = startBacktick;
        this.nameReference = nameReference;
        this.endBacktick = endBacktick;
        this.addChildren(referenceType, startBacktick, nameReference, endBacktick);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STBallerinaNameReferenceNode(this.referenceType, this.startBacktick, this.nameReference, this.endBacktick, diagnostics);
    }

    public STBallerinaNameReferenceNode modify(STNode referenceType, STNode startBacktick, STNode nameReference, STNode endBacktick) {
        if (this.checkForReferenceEquality(referenceType, startBacktick, nameReference, endBacktick)) {
            return this;
        }
        return new STBallerinaNameReferenceNode(referenceType, startBacktick, nameReference, endBacktick, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new BallerinaNameReferenceNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

