/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STActionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ClientResourceAccessActionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STClientResourceAccessActionNode
extends STActionNode {
    public final STNode expression;
    public final STNode rightArrowToken;
    public final STNode slashToken;
    public final STNode resourceAccessPath;
    public final STNode dotToken;
    public final STNode methodName;
    public final STNode arguments;

    STClientResourceAccessActionNode(STNode expression, STNode rightArrowToken, STNode slashToken, STNode resourceAccessPath, STNode dotToken, STNode methodName, STNode arguments) {
        this(expression, rightArrowToken, slashToken, resourceAccessPath, dotToken, methodName, arguments, Collections.emptyList());
    }

    STClientResourceAccessActionNode(STNode expression, STNode rightArrowToken, STNode slashToken, STNode resourceAccessPath, STNode dotToken, STNode methodName, STNode arguments, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.CLIENT_RESOURCE_ACCESS_ACTION, diagnostics);
        this.expression = expression;
        this.rightArrowToken = rightArrowToken;
        this.slashToken = slashToken;
        this.resourceAccessPath = resourceAccessPath;
        this.dotToken = dotToken;
        this.methodName = methodName;
        this.arguments = arguments;
        this.addChildren(expression, rightArrowToken, slashToken, resourceAccessPath, dotToken, methodName, arguments);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STClientResourceAccessActionNode(this.expression, this.rightArrowToken, this.slashToken, this.resourceAccessPath, this.dotToken, this.methodName, this.arguments, diagnostics);
    }

    public STClientResourceAccessActionNode modify(STNode expression, STNode rightArrowToken, STNode slashToken, STNode resourceAccessPath, STNode dotToken, STNode methodName, STNode arguments) {
        if (this.checkForReferenceEquality(expression, rightArrowToken, slashToken, resourceAccessPath, dotToken, methodName, arguments)) {
            return this;
        }
        return new STClientResourceAccessActionNode(expression, rightArrowToken, slashToken, resourceAccessPath, dotToken, methodName, arguments, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ClientResourceAccessActionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

