/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.CompoundAssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STCompoundAssignmentStatementNode
extends STStatementNode {
    public final STNode lhsExpression;
    public final STNode binaryOperator;
    public final STNode equalsToken;
    public final STNode rhsExpression;
    public final STNode semicolonToken;

    STCompoundAssignmentStatementNode(STNode lhsExpression, STNode binaryOperator, STNode equalsToken, STNode rhsExpression, STNode semicolonToken) {
        this(lhsExpression, binaryOperator, equalsToken, rhsExpression, semicolonToken, Collections.emptyList());
    }

    STCompoundAssignmentStatementNode(STNode lhsExpression, STNode binaryOperator, STNode equalsToken, STNode rhsExpression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.COMPOUND_ASSIGNMENT_STATEMENT, diagnostics);
        this.lhsExpression = lhsExpression;
        this.binaryOperator = binaryOperator;
        this.equalsToken = equalsToken;
        this.rhsExpression = rhsExpression;
        this.semicolonToken = semicolonToken;
        this.addChildren(lhsExpression, binaryOperator, equalsToken, rhsExpression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STCompoundAssignmentStatementNode(this.lhsExpression, this.binaryOperator, this.equalsToken, this.rhsExpression, this.semicolonToken, diagnostics);
    }

    public STCompoundAssignmentStatementNode modify(STNode lhsExpression, STNode binaryOperator, STNode equalsToken, STNode rhsExpression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(lhsExpression, binaryOperator, equalsToken, rhsExpression, semicolonToken)) {
            return this;
        }
        return new STCompoundAssignmentStatementNode(lhsExpression, binaryOperator, equalsToken, rhsExpression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new CompoundAssignmentStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

