/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ComputedResourceAccessSegmentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STComputedResourceAccessSegmentNode
extends STNode {
    public final STNode openBracketToken;
    public final STNode expression;
    public final STNode closeBracketToken;

    STComputedResourceAccessSegmentNode(STNode openBracketToken, STNode expression, STNode closeBracketToken) {
        this(openBracketToken, expression, closeBracketToken, Collections.emptyList());
    }

    STComputedResourceAccessSegmentNode(STNode openBracketToken, STNode expression, STNode closeBracketToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.COMPUTED_RESOURCE_ACCESS_SEGMENT, diagnostics);
        this.openBracketToken = openBracketToken;
        this.expression = expression;
        this.closeBracketToken = closeBracketToken;
        this.addChildren(openBracketToken, expression, closeBracketToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STComputedResourceAccessSegmentNode(this.openBracketToken, this.expression, this.closeBracketToken, diagnostics);
    }

    public STComputedResourceAccessSegmentNode modify(STNode openBracketToken, STNode expression, STNode closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, expression, closeBracketToken)) {
            return this;
        }
        return new STComputedResourceAccessSegmentNode(openBracketToken, expression, closeBracketToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ComputedResourceAccessSegmentNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

