/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STToken;
import io.ballerina.compiler.syntax.tree.DocumentationLineToken;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDocumentationLineToken
extends STToken {
    private final String text;

    STDocumentationLineToken(String text, STNode leadingTrivia, STNode trailingTrivia) {
        this(text, leadingTrivia, trailingTrivia, Collections.emptyList());
    }

    STDocumentationLineToken(String text, STNode leadingTrivia, STNode trailingTrivia, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MARKDOWN_DOCUMENTATION_LINE, text.length(), leadingTrivia, trailingTrivia, diagnostics);
        this.text = text;
    }

    @Override
    public String text() {
        return this.text;
    }

    @Override
    public STToken modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDocumentationLineToken(this.text, this.leadingMinutiae, this.trailingMinutiae, diagnostics);
    }

    @Override
    public STToken modifyWith(STNode leadingMinutiae, STNode trailingMinutiae) {
        return new STDocumentationLineToken(this.text, leadingMinutiae, trailingMinutiae, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new DocumentationLineToken(this, position, parent);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }

    @Override
    public String toString() {
        return String.valueOf(this.leadingMinutiae) + this.text + String.valueOf(this.trailingMinutiae);
    }

    @Override
    public void writeTo(StringBuilder builder) {
        this.leadingMinutiae.writeTo(builder);
        builder.append(this.text);
        this.trailingMinutiae.writeTo(builder);
    }
}

