/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.FailStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STFailStatementNode
extends STStatementNode {
    public final STNode failKeyword;
    public final STNode expression;
    public final STNode semicolonToken;

    STFailStatementNode(STNode failKeyword, STNode expression, STNode semicolonToken) {
        this(failKeyword, expression, semicolonToken, Collections.emptyList());
    }

    STFailStatementNode(STNode failKeyword, STNode expression, STNode semicolonToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.FAIL_STATEMENT, diagnostics);
        this.failKeyword = failKeyword;
        this.expression = expression;
        this.semicolonToken = semicolonToken;
        this.addChildren(failKeyword, expression, semicolonToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STFailStatementNode(this.failKeyword, this.expression, this.semicolonToken, diagnostics);
    }

    public STFailStatementNode modify(STNode failKeyword, STNode expression, STNode semicolonToken) {
        if (this.checkForReferenceEquality(failKeyword, expression, semicolonToken)) {
            return this;
        }
        return new STFailStatementNode(failKeyword, expression, semicolonToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new FailStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

