/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ListBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STListBindingPatternNode
extends STBindingPatternNode {
    public final STNode openBracket;
    public final STNode bindingPatterns;
    public final STNode closeBracket;

    STListBindingPatternNode(STNode openBracket, STNode bindingPatterns, STNode closeBracket) {
        this(openBracket, bindingPatterns, closeBracket, Collections.emptyList());
    }

    STListBindingPatternNode(STNode openBracket, STNode bindingPatterns, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.LIST_BINDING_PATTERN, diagnostics);
        this.openBracket = openBracket;
        this.bindingPatterns = bindingPatterns;
        this.closeBracket = closeBracket;
        this.addChildren(openBracket, bindingPatterns, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STListBindingPatternNode(this.openBracket, this.bindingPatterns, this.closeBracket, diagnostics);
    }

    public STListBindingPatternNode modify(STNode openBracket, STNode bindingPatterns, STNode closeBracket) {
        if (this.checkForReferenceEquality(openBracket, bindingPatterns, closeBracket)) {
            return this;
        }
        return new STListBindingPatternNode(openBracket, bindingPatterns, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ListBindingPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

