/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ObjectConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STObjectConstructorExpressionNode
extends STExpressionNode {
    public final STNode annotations;
    public final STNode objectTypeQualifiers;
    public final STNode objectKeyword;
    public final STNode typeReference;
    public final STNode openBraceToken;
    public final STNode members;
    public final STNode closeBraceToken;

    STObjectConstructorExpressionNode(STNode annotations, STNode objectTypeQualifiers, STNode objectKeyword, STNode typeReference, STNode openBraceToken, STNode members, STNode closeBraceToken) {
        this(annotations, objectTypeQualifiers, objectKeyword, typeReference, openBraceToken, members, closeBraceToken, Collections.emptyList());
    }

    STObjectConstructorExpressionNode(STNode annotations, STNode objectTypeQualifiers, STNode objectKeyword, STNode typeReference, STNode openBraceToken, STNode members, STNode closeBraceToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.OBJECT_CONSTRUCTOR, diagnostics);
        this.annotations = annotations;
        this.objectTypeQualifiers = objectTypeQualifiers;
        this.objectKeyword = objectKeyword;
        this.typeReference = typeReference;
        this.openBraceToken = openBraceToken;
        this.members = members;
        this.closeBraceToken = closeBraceToken;
        this.addChildren(annotations, objectTypeQualifiers, objectKeyword, typeReference, openBraceToken, members, closeBraceToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STObjectConstructorExpressionNode(this.annotations, this.objectTypeQualifiers, this.objectKeyword, this.typeReference, this.openBraceToken, this.members, this.closeBraceToken, diagnostics);
    }

    public STObjectConstructorExpressionNode modify(STNode annotations, STNode objectTypeQualifiers, STNode objectKeyword, STNode typeReference, STNode openBraceToken, STNode members, STNode closeBraceToken) {
        if (this.checkForReferenceEquality(annotations, objectTypeQualifiers, objectKeyword, typeReference, openBraceToken, members, closeBraceToken)) {
            return this;
        }
        return new STObjectConstructorExpressionNode(annotations, objectTypeQualifiers, objectKeyword, typeReference, openBraceToken, members, closeBraceToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ObjectConstructorExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

