/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STExpressionNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TableConstructorExpressionNode;
import java.util.Collection;
import java.util.Collections;

public class STTableConstructorExpressionNode
extends STExpressionNode {
    public final STNode tableKeyword;
    public final STNode keySpecifier;
    public final STNode openBracket;
    public final STNode rows;
    public final STNode closeBracket;

    STTableConstructorExpressionNode(STNode tableKeyword, STNode keySpecifier, STNode openBracket, STNode rows, STNode closeBracket) {
        this(tableKeyword, keySpecifier, openBracket, rows, closeBracket, Collections.emptyList());
    }

    STTableConstructorExpressionNode(STNode tableKeyword, STNode keySpecifier, STNode openBracket, STNode rows, STNode closeBracket, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TABLE_CONSTRUCTOR, diagnostics);
        this.tableKeyword = tableKeyword;
        this.keySpecifier = keySpecifier;
        this.openBracket = openBracket;
        this.rows = rows;
        this.closeBracket = closeBracket;
        this.addChildren(tableKeyword, keySpecifier, openBracket, rows, closeBracket);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTableConstructorExpressionNode(this.tableKeyword, this.keySpecifier, this.openBracket, this.rows, this.closeBracket, diagnostics);
    }

    public STTableConstructorExpressionNode modify(STNode tableKeyword, STNode keySpecifier, STNode openBracket, STNode rows, STNode closeBracket) {
        if (this.checkForReferenceEquality(tableKeyword, keySpecifier, openBracket, rows, closeBracket)) {
            return this;
        }
        return new STTableConstructorExpressionNode(tableKeyword, keySpecifier, openBracket, rows, closeBracket, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TableConstructorExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

