/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TransactionStatementNode;
import java.util.Collection;
import java.util.Collections;

public class STTransactionStatementNode
extends STStatementNode {
    public final STNode transactionKeyword;
    public final STNode blockStatement;
    public final STNode onFailClause;

    STTransactionStatementNode(STNode transactionKeyword, STNode blockStatement, STNode onFailClause) {
        this(transactionKeyword, blockStatement, onFailClause, Collections.emptyList());
    }

    STTransactionStatementNode(STNode transactionKeyword, STNode blockStatement, STNode onFailClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.TRANSACTION_STATEMENT, diagnostics);
        this.transactionKeyword = transactionKeyword;
        this.blockStatement = blockStatement;
        this.onFailClause = onFailClause;
        this.addChildren(transactionKeyword, blockStatement, onFailClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STTransactionStatementNode(this.transactionKeyword, this.blockStatement, this.onFailClause, diagnostics);
    }

    public STTransactionStatementNode modify(STNode transactionKeyword, STNode blockStatement, STNode onFailClause) {
        if (this.checkForReferenceEquality(transactionKeyword, blockStatement, onFailClause)) {
            return this;
        }
        return new STTransactionStatementNode(transactionKeyword, blockStatement, onFailClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new TransactionStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

