/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.WaitFieldNode;
import java.util.Collection;
import java.util.Collections;

public class STWaitFieldNode
extends STNode {
    public final STNode fieldName;
    public final STNode colon;
    public final STNode waitFutureExpr;

    STWaitFieldNode(STNode fieldName, STNode colon, STNode waitFutureExpr) {
        this(fieldName, colon, waitFutureExpr, Collections.emptyList());
    }

    STWaitFieldNode(STNode fieldName, STNode colon, STNode waitFutureExpr, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.WAIT_FIELD, diagnostics);
        this.fieldName = fieldName;
        this.colon = colon;
        this.waitFutureExpr = waitFutureExpr;
        this.addChildren(fieldName, colon, waitFutureExpr);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STWaitFieldNode(this.fieldName, this.colon, this.waitFutureExpr, diagnostics);
    }

    public STWaitFieldNode modify(STNode fieldName, STNode colon, STNode waitFutureExpr) {
        if (this.checkForReferenceEquality(fieldName, colon, waitFutureExpr)) {
            return this;
        }
        return new STWaitFieldNode(fieldName, colon, waitFutureExpr, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new WaitFieldNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

