/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.XMLAttributeNode;
import java.util.Collection;
import java.util.Collections;

public class STXMLAttributeNode
extends STNode {
    public final STNode attributeName;
    public final STNode equalToken;
    public final STNode value;

    STXMLAttributeNode(STNode attributeName, STNode equalToken, STNode value) {
        this(attributeName, equalToken, value, Collections.emptyList());
    }

    STXMLAttributeNode(STNode attributeName, STNode equalToken, STNode value, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.XML_ATTRIBUTE, diagnostics);
        this.attributeName = attributeName;
        this.equalToken = equalToken;
        this.value = value;
        this.addChildren(attributeName, equalToken, value);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STXMLAttributeNode(this.attributeName, this.equalToken, this.value, diagnostics);
    }

    public STXMLAttributeNode modify(STNode attributeName, STNode equalToken, STNode value) {
        if (this.checkForReferenceEquality(attributeName, equalToken, value)) {
            return this;
        }
        return new STXMLAttributeNode(attributeName, equalToken, value, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new XMLAttributeNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

