/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class AnnotationAttachPointNode
extends NonTerminalNode {
    public AnnotationAttachPointNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Optional<Token> sourceKeyword() {
        return this.optionalChildInBucket(0);
    }

    public NodeList<Token> identifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(1));
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"sourceKeyword", "identifiers"};
    }

    public AnnotationAttachPointNode modify(Token sourceKeyword, NodeList<Token> identifiers) {
        if (this.checkForReferenceEquality(sourceKeyword, identifiers.underlyingListNode())) {
            return this;
        }
        return NodeFactory.createAnnotationAttachPointNode(sourceKeyword, identifiers);
    }

    public AnnotationAttachPointNodeModifier modify() {
        return new AnnotationAttachPointNodeModifier(this);
    }

    public static class AnnotationAttachPointNodeModifier {
        private final AnnotationAttachPointNode oldNode;
        private Token sourceKeyword;
        private NodeList<Token> identifiers;

        public AnnotationAttachPointNodeModifier(AnnotationAttachPointNode oldNode) {
            this.oldNode = oldNode;
            this.sourceKeyword = oldNode.sourceKeyword().orElse(null);
            this.identifiers = oldNode.identifiers();
        }

        public AnnotationAttachPointNodeModifier withSourceKeyword(Token sourceKeyword) {
            this.sourceKeyword = sourceKeyword;
            return this;
        }

        public AnnotationAttachPointNodeModifier withIdentifiers(NodeList<Token> identifiers) {
            Objects.requireNonNull(identifiers, "identifiers must not be null");
            this.identifiers = identifiers;
            return this;
        }

        public AnnotationAttachPointNode apply() {
            return this.oldNode.modify(this.sourceKeyword, this.identifiers);
        }
    }
}

