/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class AssignmentStatementNode
extends StatementNode {
    public AssignmentStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node varRef() {
        return this.childInBucket(0);
    }

    public Token equalsToken() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"varRef", "equalsToken", "expression", "semicolonToken"};
    }

    public AssignmentStatementNode modify(Node varRef, Token equalsToken, ExpressionNode expression, Token semicolonToken) {
        if (this.checkForReferenceEquality(varRef, equalsToken, expression, semicolonToken)) {
            return this;
        }
        return NodeFactory.createAssignmentStatementNode(varRef, equalsToken, expression, semicolonToken);
    }

    public AssignmentStatementNodeModifier modify() {
        return new AssignmentStatementNodeModifier(this);
    }

    public static class AssignmentStatementNodeModifier {
        private final AssignmentStatementNode oldNode;
        private Node varRef;
        private Token equalsToken;
        private ExpressionNode expression;
        private Token semicolonToken;

        public AssignmentStatementNodeModifier(AssignmentStatementNode oldNode) {
            this.oldNode = oldNode;
            this.varRef = oldNode.varRef();
            this.equalsToken = oldNode.equalsToken();
            this.expression = oldNode.expression();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public AssignmentStatementNodeModifier withVarRef(Node varRef) {
            Objects.requireNonNull(varRef, "varRef must not be null");
            this.varRef = varRef;
            return this;
        }

        public AssignmentStatementNodeModifier withEqualsToken(Token equalsToken) {
            Objects.requireNonNull(equalsToken, "equalsToken must not be null");
            this.equalsToken = equalsToken;
            return this;
        }

        public AssignmentStatementNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public AssignmentStatementNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public AssignmentStatementNode apply() {
            return this.oldNode.modify(this.varRef, this.equalsToken, this.expression, this.semicolonToken);
        }
    }
}

