/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ClauseNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class CollectClauseNode
extends ClauseNode {
    public CollectClauseNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token collectKeyword() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"collectKeyword", "expression"};
    }

    public CollectClauseNode modify(Token collectKeyword, ExpressionNode expression) {
        if (this.checkForReferenceEquality(collectKeyword, expression)) {
            return this;
        }
        return NodeFactory.createCollectClauseNode(collectKeyword, expression);
    }

    public CollectClauseNodeModifier modify() {
        return new CollectClauseNodeModifier(this);
    }

    public static class CollectClauseNodeModifier {
        private final CollectClauseNode oldNode;
        private Token collectKeyword;
        private ExpressionNode expression;

        public CollectClauseNodeModifier(CollectClauseNode oldNode) {
            this.oldNode = oldNode;
            this.collectKeyword = oldNode.collectKeyword();
            this.expression = oldNode.expression();
        }

        public CollectClauseNodeModifier withCollectKeyword(Token collectKeyword) {
            Objects.requireNonNull(collectKeyword, "collectKeyword must not be null");
            this.collectKeyword = collectKeyword;
            return this;
        }

        public CollectClauseNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public CollectClauseNode apply() {
            return this.oldNode.modify(this.collectKeyword, this.expression);
        }
    }
}

