/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class DistinctTypeDescriptorNode
extends TypeDescriptorNode {
    public DistinctTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token distinctKeyword() {
        return (Token)this.childInBucket(0);
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"distinctKeyword", "typeDescriptor"};
    }

    public DistinctTypeDescriptorNode modify(Token distinctKeyword, TypeDescriptorNode typeDescriptor) {
        if (this.checkForReferenceEquality(distinctKeyword, typeDescriptor)) {
            return this;
        }
        return NodeFactory.createDistinctTypeDescriptorNode(distinctKeyword, typeDescriptor);
    }

    public DistinctTypeDescriptorNodeModifier modify() {
        return new DistinctTypeDescriptorNodeModifier(this);
    }

    public static class DistinctTypeDescriptorNodeModifier {
        private final DistinctTypeDescriptorNode oldNode;
        private Token distinctKeyword;
        private TypeDescriptorNode typeDescriptor;

        public DistinctTypeDescriptorNodeModifier(DistinctTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.distinctKeyword = oldNode.distinctKeyword();
            this.typeDescriptor = oldNode.typeDescriptor();
        }

        public DistinctTypeDescriptorNodeModifier withDistinctKeyword(Token distinctKeyword) {
            Objects.requireNonNull(distinctKeyword, "distinctKeyword must not be null");
            this.distinctKeyword = distinctKeyword;
            return this;
        }

        public DistinctTypeDescriptorNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public DistinctTypeDescriptorNode apply() {
            return this.oldNode.modify(this.distinctKeyword, this.typeDescriptor);
        }
    }
}

