/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class DoStatementNode
extends StatementNode {
    public DoStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token doKeyword() {
        return (Token)this.childInBucket(0);
    }

    public BlockStatementNode blockStatement() {
        return (BlockStatementNode)this.childInBucket(1);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"doKeyword", "blockStatement", "onFailClause"};
    }

    public DoStatementNode modify(Token doKeyword, BlockStatementNode blockStatement, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(doKeyword, blockStatement, onFailClause)) {
            return this;
        }
        return NodeFactory.createDoStatementNode(doKeyword, blockStatement, onFailClause);
    }

    public DoStatementNodeModifier modify() {
        return new DoStatementNodeModifier(this);
    }

    public static class DoStatementNodeModifier {
        private final DoStatementNode oldNode;
        private Token doKeyword;
        private BlockStatementNode blockStatement;
        private OnFailClauseNode onFailClause;

        public DoStatementNodeModifier(DoStatementNode oldNode) {
            this.oldNode = oldNode;
            this.doKeyword = oldNode.doKeyword();
            this.blockStatement = oldNode.blockStatement();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public DoStatementNodeModifier withDoKeyword(Token doKeyword) {
            Objects.requireNonNull(doKeyword, "doKeyword must not be null");
            this.doKeyword = doKeyword;
            return this;
        }

        public DoStatementNodeModifier withBlockStatement(BlockStatementNode blockStatement) {
            Objects.requireNonNull(blockStatement, "blockStatement must not be null");
            this.blockStatement = blockStatement;
            return this;
        }

        public DoStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public DoStatementNode apply() {
            return this.oldNode.modify(this.doKeyword, this.blockStatement, this.onFailClause);
        }
    }
}

