/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnonymousFunctionExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ImplicitAnonymousFunctionExpressionNode
extends AnonymousFunctionExpressionNode {
    public ImplicitAnonymousFunctionExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node params() {
        return this.childInBucket(0);
    }

    public Token rightDoubleArrow() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"params", "rightDoubleArrow", "expression"};
    }

    public ImplicitAnonymousFunctionExpressionNode modify(Node params, Token rightDoubleArrow, ExpressionNode expression) {
        if (this.checkForReferenceEquality(params, rightDoubleArrow, expression)) {
            return this;
        }
        return NodeFactory.createImplicitAnonymousFunctionExpressionNode(params, rightDoubleArrow, expression);
    }

    public ImplicitAnonymousFunctionExpressionNodeModifier modify() {
        return new ImplicitAnonymousFunctionExpressionNodeModifier(this);
    }

    public static class ImplicitAnonymousFunctionExpressionNodeModifier {
        private final ImplicitAnonymousFunctionExpressionNode oldNode;
        private Node params;
        private Token rightDoubleArrow;
        private ExpressionNode expression;

        public ImplicitAnonymousFunctionExpressionNodeModifier(ImplicitAnonymousFunctionExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.params = oldNode.params();
            this.rightDoubleArrow = oldNode.rightDoubleArrow();
            this.expression = oldNode.expression();
        }

        public ImplicitAnonymousFunctionExpressionNodeModifier withParams(Node params) {
            Objects.requireNonNull(params, "params must not be null");
            this.params = params;
            return this;
        }

        public ImplicitAnonymousFunctionExpressionNodeModifier withRightDoubleArrow(Token rightDoubleArrow) {
            Objects.requireNonNull(rightDoubleArrow, "rightDoubleArrow must not be null");
            this.rightDoubleArrow = rightDoubleArrow;
            return this;
        }

        public ImplicitAnonymousFunctionExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public ImplicitAnonymousFunctionExpressionNode apply() {
            return this.oldNode.modify(this.params, this.rightDoubleArrow, this.expression);
        }
    }
}

