/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.DocumentationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class InlineCodeReferenceNode
extends DocumentationNode {
    public InlineCodeReferenceNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token startBacktick() {
        return (Token)this.childInBucket(0);
    }

    public Token codeReference() {
        return (Token)this.childInBucket(1);
    }

    public Token endBacktick() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"startBacktick", "codeReference", "endBacktick"};
    }

    public InlineCodeReferenceNode modify(Token startBacktick, Token codeReference, Token endBacktick) {
        if (this.checkForReferenceEquality(startBacktick, codeReference, endBacktick)) {
            return this;
        }
        return NodeFactory.createInlineCodeReferenceNode(startBacktick, codeReference, endBacktick);
    }

    public InlineCodeReferenceNodeModifier modify() {
        return new InlineCodeReferenceNodeModifier(this);
    }

    public static class InlineCodeReferenceNodeModifier {
        private final InlineCodeReferenceNode oldNode;
        private Token startBacktick;
        private Token codeReference;
        private Token endBacktick;

        public InlineCodeReferenceNodeModifier(InlineCodeReferenceNode oldNode) {
            this.oldNode = oldNode;
            this.startBacktick = oldNode.startBacktick();
            this.codeReference = oldNode.codeReference();
            this.endBacktick = oldNode.endBacktick();
        }

        public InlineCodeReferenceNodeModifier withStartBacktick(Token startBacktick) {
            Objects.requireNonNull(startBacktick, "startBacktick must not be null");
            this.startBacktick = startBacktick;
            return this;
        }

        public InlineCodeReferenceNodeModifier withCodeReference(Token codeReference) {
            Objects.requireNonNull(codeReference, "codeReference must not be null");
            this.codeReference = codeReference;
            return this;
        }

        public InlineCodeReferenceNodeModifier withEndBacktick(Token endBacktick) {
            Objects.requireNonNull(endBacktick, "endBacktick must not be null");
            this.endBacktick = endBacktick;
            return this;
        }

        public InlineCodeReferenceNode apply() {
            return this.oldNode.modify(this.startBacktick, this.codeReference, this.endBacktick);
        }
    }
}

