/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class ObjectTypeDescriptorNode
extends TypeDescriptorNode {
    public ObjectTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<Token> objectTypeQualifiers() {
        return new NodeList<Token>((NonTerminalNode)this.childInBucket(0));
    }

    public Token objectKeyword() {
        return (Token)this.childInBucket(1);
    }

    public Token openBrace() {
        return (Token)this.childInBucket(2);
    }

    public NodeList<Node> members() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(3));
    }

    public Token closeBrace() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"objectTypeQualifiers", "objectKeyword", "openBrace", "members", "closeBrace"};
    }

    public ObjectTypeDescriptorNode modify(NodeList<Token> objectTypeQualifiers, Token objectKeyword, Token openBrace, NodeList<Node> members, Token closeBrace) {
        if (this.checkForReferenceEquality(objectTypeQualifiers.underlyingListNode(), objectKeyword, openBrace, members.underlyingListNode(), closeBrace)) {
            return this;
        }
        return NodeFactory.createObjectTypeDescriptorNode(objectTypeQualifiers, objectKeyword, openBrace, members, closeBrace);
    }

    public ObjectTypeDescriptorNodeModifier modify() {
        return new ObjectTypeDescriptorNodeModifier(this);
    }

    public static class ObjectTypeDescriptorNodeModifier {
        private final ObjectTypeDescriptorNode oldNode;
        private NodeList<Token> objectTypeQualifiers;
        private Token objectKeyword;
        private Token openBrace;
        private NodeList<Node> members;
        private Token closeBrace;

        public ObjectTypeDescriptorNodeModifier(ObjectTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.objectTypeQualifiers = oldNode.objectTypeQualifiers();
            this.objectKeyword = oldNode.objectKeyword();
            this.openBrace = oldNode.openBrace();
            this.members = oldNode.members();
            this.closeBrace = oldNode.closeBrace();
        }

        public ObjectTypeDescriptorNodeModifier withObjectTypeQualifiers(NodeList<Token> objectTypeQualifiers) {
            Objects.requireNonNull(objectTypeQualifiers, "objectTypeQualifiers must not be null");
            this.objectTypeQualifiers = objectTypeQualifiers;
            return this;
        }

        public ObjectTypeDescriptorNodeModifier withObjectKeyword(Token objectKeyword) {
            Objects.requireNonNull(objectKeyword, "objectKeyword must not be null");
            this.objectKeyword = objectKeyword;
            return this;
        }

        public ObjectTypeDescriptorNodeModifier withOpenBrace(Token openBrace) {
            Objects.requireNonNull(openBrace, "openBrace must not be null");
            this.openBrace = openBrace;
            return this;
        }

        public ObjectTypeDescriptorNodeModifier withMembers(NodeList<Node> members) {
            Objects.requireNonNull(members, "members must not be null");
            this.members = members;
            return this;
        }

        public ObjectTypeDescriptorNodeModifier withCloseBrace(Token closeBrace) {
            Objects.requireNonNull(closeBrace, "closeBrace must not be null");
            this.closeBrace = closeBrace;
            return this;
        }

        public ObjectTypeDescriptorNode apply() {
            return this.oldNode.modify(this.objectTypeQualifiers, this.objectKeyword, this.openBrace, this.members, this.closeBrace);
        }
    }
}

