/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class ParenthesisedTypeDescriptorNode
extends TypeDescriptorNode {
    public ParenthesisedTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenToken() {
        return (Token)this.childInBucket(0);
    }

    public TypeDescriptorNode typedesc() {
        return (TypeDescriptorNode)this.childInBucket(1);
    }

    public Token closeParenToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenToken", "typedesc", "closeParenToken"};
    }

    public ParenthesisedTypeDescriptorNode modify(Token openParenToken, TypeDescriptorNode typedesc, Token closeParenToken) {
        if (this.checkForReferenceEquality(openParenToken, typedesc, closeParenToken)) {
            return this;
        }
        return NodeFactory.createParenthesisedTypeDescriptorNode(openParenToken, typedesc, closeParenToken);
    }

    public ParenthesisedTypeDescriptorNodeModifier modify() {
        return new ParenthesisedTypeDescriptorNodeModifier(this);
    }

    public static class ParenthesisedTypeDescriptorNodeModifier {
        private final ParenthesisedTypeDescriptorNode oldNode;
        private Token openParenToken;
        private TypeDescriptorNode typedesc;
        private Token closeParenToken;

        public ParenthesisedTypeDescriptorNodeModifier(ParenthesisedTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.openParenToken = oldNode.openParenToken();
            this.typedesc = oldNode.typedesc();
            this.closeParenToken = oldNode.closeParenToken();
        }

        public ParenthesisedTypeDescriptorNodeModifier withOpenParenToken(Token openParenToken) {
            Objects.requireNonNull(openParenToken, "openParenToken must not be null");
            this.openParenToken = openParenToken;
            return this;
        }

        public ParenthesisedTypeDescriptorNodeModifier withTypedesc(TypeDescriptorNode typedesc) {
            Objects.requireNonNull(typedesc, "typedesc must not be null");
            this.typedesc = typedesc;
            return this;
        }

        public ParenthesisedTypeDescriptorNodeModifier withCloseParenToken(Token closeParenToken) {
            Objects.requireNonNull(closeParenToken, "closeParenToken must not be null");
            this.closeParenToken = closeParenToken;
            return this;
        }

        public ParenthesisedTypeDescriptorNode apply() {
            return this.oldNode.modify(this.openParenToken, this.typedesc, this.closeParenToken);
        }
    }
}

