/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReQuantifierNode;
import io.ballerina.compiler.syntax.tree.ReTermNode;
import java.util.Objects;
import java.util.Optional;

public class ReAtomQuantifierNode
extends ReTermNode {
    public ReAtomQuantifierNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Node reAtom() {
        return this.childInBucket(0);
    }

    public Optional<ReQuantifierNode> reQuantifier() {
        return this.optionalChildInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"reAtom", "reQuantifier"};
    }

    public ReAtomQuantifierNode modify(Node reAtom, ReQuantifierNode reQuantifier) {
        if (this.checkForReferenceEquality(reAtom, reQuantifier)) {
            return this;
        }
        return NodeFactory.createReAtomQuantifierNode(reAtom, reQuantifier);
    }

    public ReAtomQuantifierNodeModifier modify() {
        return new ReAtomQuantifierNodeModifier(this);
    }

    public static class ReAtomQuantifierNodeModifier {
        private final ReAtomQuantifierNode oldNode;
        private Node reAtom;
        private ReQuantifierNode reQuantifier;

        public ReAtomQuantifierNodeModifier(ReAtomQuantifierNode oldNode) {
            this.oldNode = oldNode;
            this.reAtom = oldNode.reAtom();
            this.reQuantifier = oldNode.reQuantifier().orElse(null);
        }

        public ReAtomQuantifierNodeModifier withReAtom(Node reAtom) {
            Objects.requireNonNull(reAtom, "reAtom must not be null");
            this.reAtom = reAtom;
            return this;
        }

        public ReAtomQuantifierNodeModifier withReQuantifier(ReQuantifierNode reQuantifier) {
            this.reQuantifier = reQuantifier;
            return this;
        }

        public ReAtomQuantifierNode apply() {
            return this.oldNode.modify(this.reAtom, this.reQuantifier);
        }
    }
}

