/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReFlagExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ReCapturingGroupsNode
extends NonTerminalNode {
    public ReCapturingGroupsNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openParenthesis() {
        return (Token)this.childInBucket(0);
    }

    public Optional<ReFlagExpressionNode> reFlagExpression() {
        return this.optionalChildInBucket(1);
    }

    public NodeList<Node> reSequences() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(2));
    }

    public Token closeParenthesis() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openParenthesis", "reFlagExpression", "reSequences", "closeParenthesis"};
    }

    public ReCapturingGroupsNode modify(Token openParenthesis, ReFlagExpressionNode reFlagExpression, NodeList<Node> reSequences, Token closeParenthesis) {
        if (this.checkForReferenceEquality(openParenthesis, reFlagExpression, reSequences.underlyingListNode(), closeParenthesis)) {
            return this;
        }
        return NodeFactory.createReCapturingGroupsNode(openParenthesis, reFlagExpression, reSequences, closeParenthesis);
    }

    public ReCapturingGroupsNodeModifier modify() {
        return new ReCapturingGroupsNodeModifier(this);
    }

    public static class ReCapturingGroupsNodeModifier {
        private final ReCapturingGroupsNode oldNode;
        private Token openParenthesis;
        private ReFlagExpressionNode reFlagExpression;
        private NodeList<Node> reSequences;
        private Token closeParenthesis;

        public ReCapturingGroupsNodeModifier(ReCapturingGroupsNode oldNode) {
            this.oldNode = oldNode;
            this.openParenthesis = oldNode.openParenthesis();
            this.reFlagExpression = oldNode.reFlagExpression().orElse(null);
            this.reSequences = oldNode.reSequences();
            this.closeParenthesis = oldNode.closeParenthesis();
        }

        public ReCapturingGroupsNodeModifier withOpenParenthesis(Token openParenthesis) {
            Objects.requireNonNull(openParenthesis, "openParenthesis must not be null");
            this.openParenthesis = openParenthesis;
            return this;
        }

        public ReCapturingGroupsNodeModifier withReFlagExpression(ReFlagExpressionNode reFlagExpression) {
            this.reFlagExpression = reFlagExpression;
            return this;
        }

        public ReCapturingGroupsNodeModifier withReSequences(NodeList<Node> reSequences) {
            Objects.requireNonNull(reSequences, "reSequences must not be null");
            this.reSequences = reSequences;
            return this;
        }

        public ReCapturingGroupsNodeModifier withCloseParenthesis(Token closeParenthesis) {
            Objects.requireNonNull(closeParenthesis, "closeParenthesis must not be null");
            this.closeParenthesis = closeParenthesis;
            return this;
        }

        public ReCapturingGroupsNode apply() {
            return this.oldNode.modify(this.openParenthesis, this.reFlagExpression, this.reSequences, this.closeParenthesis);
        }
    }
}

