/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReUnicodePropertyNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ReUnicodePropertyEscapeNode
extends NonTerminalNode {
    public ReUnicodePropertyEscapeNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token slashToken() {
        return (Token)this.childInBucket(0);
    }

    public Node property() {
        return this.childInBucket(1);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(2);
    }

    public ReUnicodePropertyNode reUnicodeProperty() {
        return (ReUnicodePropertyNode)this.childInBucket(3);
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"slashToken", "property", "openBraceToken", "reUnicodeProperty", "closeBraceToken"};
    }

    public ReUnicodePropertyEscapeNode modify(Token slashToken, Node property, Token openBraceToken, ReUnicodePropertyNode reUnicodeProperty, Token closeBraceToken) {
        if (this.checkForReferenceEquality(slashToken, property, openBraceToken, reUnicodeProperty, closeBraceToken)) {
            return this;
        }
        return NodeFactory.createReUnicodePropertyEscapeNode(slashToken, property, openBraceToken, reUnicodeProperty, closeBraceToken);
    }

    public ReUnicodePropertyEscapeNodeModifier modify() {
        return new ReUnicodePropertyEscapeNodeModifier(this);
    }

    public static class ReUnicodePropertyEscapeNodeModifier {
        private final ReUnicodePropertyEscapeNode oldNode;
        private Token slashToken;
        private Node property;
        private Token openBraceToken;
        private ReUnicodePropertyNode reUnicodeProperty;
        private Token closeBraceToken;

        public ReUnicodePropertyEscapeNodeModifier(ReUnicodePropertyEscapeNode oldNode) {
            this.oldNode = oldNode;
            this.slashToken = oldNode.slashToken();
            this.property = oldNode.property();
            this.openBraceToken = oldNode.openBraceToken();
            this.reUnicodeProperty = oldNode.reUnicodeProperty();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public ReUnicodePropertyEscapeNodeModifier withSlashToken(Token slashToken) {
            Objects.requireNonNull(slashToken, "slashToken must not be null");
            this.slashToken = slashToken;
            return this;
        }

        public ReUnicodePropertyEscapeNodeModifier withProperty(Node property) {
            Objects.requireNonNull(property, "property must not be null");
            this.property = property;
            return this;
        }

        public ReUnicodePropertyEscapeNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public ReUnicodePropertyEscapeNodeModifier withReUnicodeProperty(ReUnicodePropertyNode reUnicodeProperty) {
            Objects.requireNonNull(reUnicodeProperty, "reUnicodeProperty must not be null");
            this.reUnicodeProperty = reUnicodeProperty;
            return this;
        }

        public ReUnicodePropertyEscapeNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public ReUnicodePropertyEscapeNode apply() {
            return this.oldNode.modify(this.slashToken, this.property, this.openBraceToken, this.reUnicodeProperty, this.closeBraceToken);
        }
    }
}

