/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class RequiredExpressionNode
extends ExpressionNode {
    public RequiredExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token questionMarkToken() {
        return (Token)this.childInBucket(0);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"questionMarkToken"};
    }

    public RequiredExpressionNode modify(Token questionMarkToken) {
        if (this.checkForReferenceEquality(questionMarkToken)) {
            return this;
        }
        return NodeFactory.createRequiredExpressionNode(questionMarkToken);
    }

    public RequiredExpressionNodeModifier modify() {
        return new RequiredExpressionNodeModifier(this);
    }

    public static class RequiredExpressionNodeModifier {
        private final RequiredExpressionNode oldNode;
        private Token questionMarkToken;

        public RequiredExpressionNodeModifier(RequiredExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.questionMarkToken = oldNode.questionMarkToken();
        }

        public RequiredExpressionNodeModifier withQuestionMarkToken(Token questionMarkToken) {
            Objects.requireNonNull(questionMarkToken, "questionMarkToken must not be null");
            this.questionMarkToken = questionMarkToken;
            return this;
        }

        public RequiredExpressionNode apply() {
            return this.oldNode.modify(this.questionMarkToken);
        }
    }
}

