/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ResourceAccessRestSegmentNode
extends NonTerminalNode {
    public ResourceAccessRestSegmentNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracketToken() {
        return (Token)this.childInBucket(0);
    }

    public Token ellipsisToken() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    public Token closeBracketToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracketToken", "ellipsisToken", "expression", "closeBracketToken"};
    }

    public ResourceAccessRestSegmentNode modify(Token openBracketToken, Token ellipsisToken, ExpressionNode expression, Token closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, ellipsisToken, expression, closeBracketToken)) {
            return this;
        }
        return NodeFactory.createResourceAccessRestSegmentNode(openBracketToken, ellipsisToken, expression, closeBracketToken);
    }

    public ResourceAccessRestSegmentNodeModifier modify() {
        return new ResourceAccessRestSegmentNodeModifier(this);
    }

    public static class ResourceAccessRestSegmentNodeModifier {
        private final ResourceAccessRestSegmentNode oldNode;
        private Token openBracketToken;
        private Token ellipsisToken;
        private ExpressionNode expression;
        private Token closeBracketToken;

        public ResourceAccessRestSegmentNodeModifier(ResourceAccessRestSegmentNode oldNode) {
            this.oldNode = oldNode;
            this.openBracketToken = oldNode.openBracketToken();
            this.ellipsisToken = oldNode.ellipsisToken();
            this.expression = oldNode.expression();
            this.closeBracketToken = oldNode.closeBracketToken();
        }

        public ResourceAccessRestSegmentNodeModifier withOpenBracketToken(Token openBracketToken) {
            Objects.requireNonNull(openBracketToken, "openBracketToken must not be null");
            this.openBracketToken = openBracketToken;
            return this;
        }

        public ResourceAccessRestSegmentNodeModifier withEllipsisToken(Token ellipsisToken) {
            Objects.requireNonNull(ellipsisToken, "ellipsisToken must not be null");
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public ResourceAccessRestSegmentNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public ResourceAccessRestSegmentNodeModifier withCloseBracketToken(Token closeBracketToken) {
            Objects.requireNonNull(closeBracketToken, "closeBracketToken must not be null");
            this.closeBracketToken = closeBracketToken;
            return this;
        }

        public ResourceAccessRestSegmentNode apply() {
            return this.oldNode.modify(this.openBracketToken, this.ellipsisToken, this.expression, this.closeBracketToken);
        }
    }
}

