/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;
import java.util.Optional;

public class ResourcePathParameterNode
extends NonTerminalNode {
    public ResourcePathParameterNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracketToken() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<AnnotationNode> annotations() {
        return new NodeList<AnnotationNode>((NonTerminalNode)this.childInBucket(1));
    }

    public TypeDescriptorNode typeDescriptor() {
        return (TypeDescriptorNode)this.childInBucket(2);
    }

    public Optional<Token> ellipsisToken() {
        return this.optionalChildInBucket(3);
    }

    public Optional<Token> paramName() {
        return this.optionalChildInBucket(4);
    }

    public Token closeBracketToken() {
        return (Token)this.childInBucket(5);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracketToken", "annotations", "typeDescriptor", "ellipsisToken", "paramName", "closeBracketToken"};
    }

    public ResourcePathParameterNode modify(SyntaxKind kind, Token openBracketToken, NodeList<AnnotationNode> annotations, TypeDescriptorNode typeDescriptor, Token ellipsisToken, Token paramName, Token closeBracketToken) {
        if (this.checkForReferenceEquality(openBracketToken, annotations.underlyingListNode(), typeDescriptor, ellipsisToken, paramName, closeBracketToken)) {
            return this;
        }
        return NodeFactory.createResourcePathParameterNode(kind, openBracketToken, annotations, typeDescriptor, ellipsisToken, paramName, closeBracketToken);
    }

    public ResourcePathParameterNodeModifier modify() {
        return new ResourcePathParameterNodeModifier(this);
    }

    public static class ResourcePathParameterNodeModifier {
        private final ResourcePathParameterNode oldNode;
        private Token openBracketToken;
        private NodeList<AnnotationNode> annotations;
        private TypeDescriptorNode typeDescriptor;
        private Token ellipsisToken;
        private Token paramName;
        private Token closeBracketToken;

        public ResourcePathParameterNodeModifier(ResourcePathParameterNode oldNode) {
            this.oldNode = oldNode;
            this.openBracketToken = oldNode.openBracketToken();
            this.annotations = oldNode.annotations();
            this.typeDescriptor = oldNode.typeDescriptor();
            this.ellipsisToken = oldNode.ellipsisToken().orElse(null);
            this.paramName = oldNode.paramName().orElse(null);
            this.closeBracketToken = oldNode.closeBracketToken();
        }

        public ResourcePathParameterNodeModifier withOpenBracketToken(Token openBracketToken) {
            Objects.requireNonNull(openBracketToken, "openBracketToken must not be null");
            this.openBracketToken = openBracketToken;
            return this;
        }

        public ResourcePathParameterNodeModifier withAnnotations(NodeList<AnnotationNode> annotations) {
            Objects.requireNonNull(annotations, "annotations must not be null");
            this.annotations = annotations;
            return this;
        }

        public ResourcePathParameterNodeModifier withTypeDescriptor(TypeDescriptorNode typeDescriptor) {
            Objects.requireNonNull(typeDescriptor, "typeDescriptor must not be null");
            this.typeDescriptor = typeDescriptor;
            return this;
        }

        public ResourcePathParameterNodeModifier withEllipsisToken(Token ellipsisToken) {
            this.ellipsisToken = ellipsisToken;
            return this;
        }

        public ResourcePathParameterNodeModifier withParamName(Token paramName) {
            this.paramName = paramName;
            return this;
        }

        public ResourcePathParameterNodeModifier withCloseBracketToken(Token closeBracketToken) {
            Objects.requireNonNull(closeBracketToken, "closeBracketToken must not be null");
            this.closeBracketToken = closeBracketToken;
            return this;
        }

        public ResourcePathParameterNode apply() {
            return this.oldNode.modify(this.oldNode.kind(), this.openBracketToken, this.annotations, this.typeDescriptor, this.ellipsisToken, this.paramName, this.closeBracketToken);
        }
    }
}

