/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.Objects;
import java.util.Optional;

public class RetryStatementNode
extends StatementNode {
    public RetryStatementNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token retryKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Optional<TypeParameterNode> typeParameter() {
        return this.optionalChildInBucket(1);
    }

    public Optional<ParenthesizedArgList> arguments() {
        return this.optionalChildInBucket(2);
    }

    public StatementNode retryBody() {
        return (StatementNode)this.childInBucket(3);
    }

    public Optional<OnFailClauseNode> onFailClause() {
        return this.optionalChildInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"retryKeyword", "typeParameter", "arguments", "retryBody", "onFailClause"};
    }

    public RetryStatementNode modify(Token retryKeyword, TypeParameterNode typeParameter, ParenthesizedArgList arguments, StatementNode retryBody, OnFailClauseNode onFailClause) {
        if (this.checkForReferenceEquality(retryKeyword, typeParameter, arguments, retryBody, onFailClause)) {
            return this;
        }
        return NodeFactory.createRetryStatementNode(retryKeyword, typeParameter, arguments, retryBody, onFailClause);
    }

    public RetryStatementNodeModifier modify() {
        return new RetryStatementNodeModifier(this);
    }

    public static class RetryStatementNodeModifier {
        private final RetryStatementNode oldNode;
        private Token retryKeyword;
        private TypeParameterNode typeParameter;
        private ParenthesizedArgList arguments;
        private StatementNode retryBody;
        private OnFailClauseNode onFailClause;

        public RetryStatementNodeModifier(RetryStatementNode oldNode) {
            this.oldNode = oldNode;
            this.retryKeyword = oldNode.retryKeyword();
            this.typeParameter = oldNode.typeParameter().orElse(null);
            this.arguments = oldNode.arguments().orElse(null);
            this.retryBody = oldNode.retryBody();
            this.onFailClause = oldNode.onFailClause().orElse(null);
        }

        public RetryStatementNodeModifier withRetryKeyword(Token retryKeyword) {
            Objects.requireNonNull(retryKeyword, "retryKeyword must not be null");
            this.retryKeyword = retryKeyword;
            return this;
        }

        public RetryStatementNodeModifier withTypeParameter(TypeParameterNode typeParameter) {
            this.typeParameter = typeParameter;
            return this;
        }

        public RetryStatementNodeModifier withArguments(ParenthesizedArgList arguments) {
            this.arguments = arguments;
            return this;
        }

        public RetryStatementNodeModifier withRetryBody(StatementNode retryBody) {
            Objects.requireNonNull(retryBody, "retryBody must not be null");
            this.retryBody = retryBody;
            return this;
        }

        public RetryStatementNodeModifier withOnFailClause(OnFailClauseNode onFailClause) {
            this.onFailClause = onFailClause;
            return this;
        }

        public RetryStatementNode apply() {
            return this.oldNode.modify(this.retryKeyword, this.typeParameter, this.arguments, this.retryBody, this.onFailClause);
        }
    }
}

