/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.syntax.NodeListUtils;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Collection;

public class SeparatedNodeList<T extends Node>
extends NodeList<T> {
    private final int separatorSize;

    SeparatedNodeList(NonTerminalNode node) {
        super(node, (node.bucketCount() + 1) / 2);
        this.separatorSize = this.size != 0 ? this.size - 1 : 0;
    }

    @Override
    public T get(int index) {
        NodeListUtils.rangeCheck(index, this.size);
        return this.nonTerminalNode.childInBucket(index * 2);
    }

    @Override
    public NodeList<T> add(T node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList<T> add(int index, T node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList<T> addAll(Collection<T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList<T> set(int index, T node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList<T> remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList<T> remove(T node) {
        throw new UnsupportedOperationException();
    }

    @Override
    public NodeList<T> removeAll(Collection<T> c) {
        throw new UnsupportedOperationException();
    }

    public int separatorSize() {
        return this.separatorSize;
    }

    public Token getSeparator(int index) {
        NodeListUtils.rangeCheck(index, this.separatorSize);
        return (Token)this.nonTerminalNode.childInBucket(index * 2 + 1);
    }
}

