/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import java.util.Objects;

public class TypeReferenceNode
extends TypeDescriptorNode {
    public TypeReferenceNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token asteriskToken() {
        return (Token)this.childInBucket(0);
    }

    public Node typeName() {
        return this.childInBucket(1);
    }

    public Token semicolonToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"asteriskToken", "typeName", "semicolonToken"};
    }

    public TypeReferenceNode modify(Token asteriskToken, Node typeName, Token semicolonToken) {
        if (this.checkForReferenceEquality(asteriskToken, typeName, semicolonToken)) {
            return this;
        }
        return NodeFactory.createTypeReferenceNode(asteriskToken, typeName, semicolonToken);
    }

    public TypeReferenceNodeModifier modify() {
        return new TypeReferenceNodeModifier(this);
    }

    public static class TypeReferenceNodeModifier {
        private final TypeReferenceNode oldNode;
        private Token asteriskToken;
        private Node typeName;
        private Token semicolonToken;

        public TypeReferenceNodeModifier(TypeReferenceNode oldNode) {
            this.oldNode = oldNode;
            this.asteriskToken = oldNode.asteriskToken();
            this.typeName = oldNode.typeName();
            this.semicolonToken = oldNode.semicolonToken();
        }

        public TypeReferenceNodeModifier withAsteriskToken(Token asteriskToken) {
            Objects.requireNonNull(asteriskToken, "asteriskToken must not be null");
            this.asteriskToken = asteriskToken;
            return this;
        }

        public TypeReferenceNodeModifier withTypeName(Node typeName) {
            Objects.requireNonNull(typeName, "typeName must not be null");
            this.typeName = typeName;
            return this;
        }

        public TypeReferenceNodeModifier withSemicolonToken(Token semicolonToken) {
            Objects.requireNonNull(semicolonToken, "semicolonToken must not be null");
            this.semicolonToken = semicolonToken;
            return this;
        }

        public TypeReferenceNode apply() {
            return this.oldNode.modify(this.asteriskToken, this.typeName, this.semicolonToken);
        }
    }
}

