/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class UnaryExpressionNode
extends ExpressionNode {
    public UnaryExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token unaryOperator() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"unaryOperator", "expression"};
    }

    public UnaryExpressionNode modify(Token unaryOperator, ExpressionNode expression) {
        if (this.checkForReferenceEquality(unaryOperator, expression)) {
            return this;
        }
        return NodeFactory.createUnaryExpressionNode(unaryOperator, expression);
    }

    public UnaryExpressionNodeModifier modify() {
        return new UnaryExpressionNodeModifier(this);
    }

    public static class UnaryExpressionNodeModifier {
        private final UnaryExpressionNode oldNode;
        private Token unaryOperator;
        private ExpressionNode expression;

        public UnaryExpressionNodeModifier(UnaryExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.unaryOperator = oldNode.unaryOperator();
            this.expression = oldNode.expression();
        }

        public UnaryExpressionNodeModifier withUnaryOperator(Token unaryOperator) {
            Objects.requireNonNull(unaryOperator, "unaryOperator must not be null");
            this.unaryOperator = unaryOperator;
            return this;
        }

        public UnaryExpressionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public UnaryExpressionNode apply() {
            return this.oldNode.modify(this.unaryOperator, this.expression);
        }
    }
}

