/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class WaitActionNode
extends ActionNode {
    public WaitActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token waitKeyword() {
        return (Token)this.childInBucket(0);
    }

    public Node waitFutureExpr() {
        return this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"waitKeyword", "waitFutureExpr"};
    }

    public WaitActionNode modify(Token waitKeyword, Node waitFutureExpr) {
        if (this.checkForReferenceEquality(waitKeyword, waitFutureExpr)) {
            return this;
        }
        return NodeFactory.createWaitActionNode(waitKeyword, waitFutureExpr);
    }

    public WaitActionNodeModifier modify() {
        return new WaitActionNodeModifier(this);
    }

    public static class WaitActionNodeModifier {
        private final WaitActionNode oldNode;
        private Token waitKeyword;
        private Node waitFutureExpr;

        public WaitActionNodeModifier(WaitActionNode oldNode) {
            this.oldNode = oldNode;
            this.waitKeyword = oldNode.waitKeyword();
            this.waitFutureExpr = oldNode.waitFutureExpr();
        }

        public WaitActionNodeModifier withWaitKeyword(Token waitKeyword) {
            Objects.requireNonNull(waitKeyword, "waitKeyword must not be null");
            this.waitKeyword = waitKeyword;
            return this;
        }

        public WaitActionNodeModifier withWaitFutureExpr(Node waitFutureExpr) {
            Objects.requireNonNull(waitFutureExpr, "waitFutureExpr must not be null");
            this.waitFutureExpr = waitFutureExpr;
            return this;
        }

        public WaitActionNode apply() {
            return this.oldNode.modify(this.waitKeyword, this.waitFutureExpr);
        }
    }
}

