/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLItemNode;
import java.util.Objects;

public class XMLCDATANode
extends XMLItemNode {
    public XMLCDATANode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token cdataStart() {
        return (Token)this.childInBucket(0);
    }

    public NodeList<Node> content() {
        return new NodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token cdataEnd() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"cdataStart", "content", "cdataEnd"};
    }

    public XMLCDATANode modify(Token cdataStart, NodeList<Node> content, Token cdataEnd) {
        if (this.checkForReferenceEquality(cdataStart, content.underlyingListNode(), cdataEnd)) {
            return this;
        }
        return NodeFactory.createXMLCDATANode(cdataStart, content, cdataEnd);
    }

    public XMLCDATANodeModifier modify() {
        return new XMLCDATANodeModifier(this);
    }

    public static class XMLCDATANodeModifier {
        private final XMLCDATANode oldNode;
        private Token cdataStart;
        private NodeList<Node> content;
        private Token cdataEnd;

        public XMLCDATANodeModifier(XMLCDATANode oldNode) {
            this.oldNode = oldNode;
            this.cdataStart = oldNode.cdataStart();
            this.content = oldNode.content();
            this.cdataEnd = oldNode.cdataEnd();
        }

        public XMLCDATANodeModifier withCdataStart(Token cdataStart) {
            Objects.requireNonNull(cdataStart, "cdataStart must not be null");
            this.cdataStart = cdataStart;
            return this;
        }

        public XMLCDATANodeModifier withContent(NodeList<Node> content) {
            Objects.requireNonNull(content, "content must not be null");
            this.content = content;
            return this;
        }

        public XMLCDATANodeModifier withCdataEnd(Token cdataEnd) {
            Objects.requireNonNull(cdataEnd, "cdataEnd must not be null");
            this.cdataEnd = cdataEnd;
            return this;
        }

        public XMLCDATANode apply() {
            return this.oldNode.modify(this.cdataStart, this.content, this.cdataEnd);
        }
    }
}

