/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.XMLAttributeNode;
import io.ballerina.compiler.syntax.tree.XMLElementTagNode;
import io.ballerina.compiler.syntax.tree.XMLNameNode;
import java.util.Objects;

public class XMLStartTagNode
extends XMLElementTagNode {
    public XMLStartTagNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ltToken() {
        return (Token)this.childInBucket(0);
    }

    public XMLNameNode name() {
        return (XMLNameNode)this.childInBucket(1);
    }

    public NodeList<XMLAttributeNode> attributes() {
        return new NodeList<XMLAttributeNode>((NonTerminalNode)this.childInBucket(2));
    }

    public Token getToken() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ltToken", "name", "attributes", "getToken"};
    }

    public XMLStartTagNode modify(Token ltToken, XMLNameNode name, NodeList<XMLAttributeNode> attributes, Token getToken) {
        if (this.checkForReferenceEquality(ltToken, name, attributes.underlyingListNode(), getToken)) {
            return this;
        }
        return NodeFactory.createXMLStartTagNode(ltToken, name, attributes, getToken);
    }

    public XMLStartTagNodeModifier modify() {
        return new XMLStartTagNodeModifier(this);
    }

    public static class XMLStartTagNodeModifier {
        private final XMLStartTagNode oldNode;
        private Token ltToken;
        private XMLNameNode name;
        private NodeList<XMLAttributeNode> attributes;
        private Token getToken;

        public XMLStartTagNodeModifier(XMLStartTagNode oldNode) {
            this.oldNode = oldNode;
            this.ltToken = oldNode.ltToken();
            this.name = oldNode.name();
            this.attributes = oldNode.attributes();
            this.getToken = oldNode.getToken();
        }

        public XMLStartTagNodeModifier withLtToken(Token ltToken) {
            Objects.requireNonNull(ltToken, "ltToken must not be null");
            this.ltToken = ltToken;
            return this;
        }

        public XMLStartTagNodeModifier withName(XMLNameNode name) {
            Objects.requireNonNull(name, "name must not be null");
            this.name = name;
            return this;
        }

        public XMLStartTagNodeModifier withAttributes(NodeList<XMLAttributeNode> attributes) {
            Objects.requireNonNull(attributes, "attributes must not be null");
            this.attributes = attributes;
            return this;
        }

        public XMLStartTagNodeModifier withGetToken(Token getToken) {
            Objects.requireNonNull(getToken, "getToken must not be null");
            this.getToken = getToken;
            return this;
        }

        public XMLStartTagNode apply() {
            return this.oldNode.modify(this.ltToken, this.name, this.attributes, this.getToken);
        }
    }
}

