/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.concurrent.CompletableFuture;

public class DataContext {
    private final Environment environment;
    private final HttpClientConnector clientConnector;
    private final BObject requestObj;
    private final CompletableFuture<Object> balFuture;
    private final HttpCarbonMessage correlatedMessage;

    public DataContext(Environment environment, CompletableFuture<Object> balFuture, HttpClientConnector clientConnector, BObject requestObj, HttpCarbonMessage outboundRequestMsg) {
        this.environment = environment;
        this.balFuture = balFuture;
        this.clientConnector = clientConnector;
        this.requestObj = requestObj;
        this.correlatedMessage = outboundRequestMsg;
    }

    public DataContext(Environment environment, CompletableFuture<Object> balFuture, HttpCarbonMessage inboundRequestMsg) {
        this.environment = environment;
        this.balFuture = balFuture;
        this.clientConnector = null;
        this.requestObj = null;
        this.correlatedMessage = inboundRequestMsg;
    }

    public void notifyInboundResponseStatus(BObject inboundResponse, BError httpConnectorError) {
        if (inboundResponse != null) {
            this.getFuture().complete(inboundResponse);
        } else if (httpConnectorError != null) {
            this.getFuture().complete((Object)httpConnectorError);
        } else {
            BError err = HttpUtil.createHttpError("inbound response retrieval error", HttpErrorType.CLIENT_ERROR);
            this.getFuture().complete((Object)err);
        }
    }

    public void notifyOutboundResponseStatus(BError httpConnectorError) {
        this.getFuture().complete((Object)httpConnectorError);
    }

    public HttpCarbonMessage getOutboundRequest() {
        return this.correlatedMessage;
    }

    public HttpClientConnector getClientConnector() {
        return this.clientConnector;
    }

    public BObject getRequestObj() {
        return this.requestObj;
    }

    public Environment getEnvironment() {
        return this.environment;
    }

    public CompletableFuture<Object> getFuture() {
        return this.balFuture;
    }
}

