/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.stdlib.http.transport.contract.PortBindingEventListener;
import java.io.PrintStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpConnectorPortBindingListener
implements PortBindingEventListener {
    private static final Logger log = LoggerFactory.getLogger(HttpConnectorPortBindingListener.class);
    private static final PrintStream console = System.out;

    @Override
    public void onOpen(String serverConnectorId, boolean isHttps) {
        if (log.isDebugEnabled()) {
            String message = isHttps ? "[ballerina/http] started HTTPS/WSS listener " : "[ballerina/http] started HTTP/WS listener ";
            log.debug(message + serverConnectorId);
        }
    }

    @Override
    public void onClose(String serverConnectorId, boolean isHttps) {
        if (log.isDebugEnabled()) {
            String message = isHttps ? "[ballerina/http] stopped HTTPS/WSS listener " : "[ballerina/http] stopped HTTP/WS listener ";
            log.debug(message + serverConnectorId);
        }
    }

    @Override
    public void onError(Throwable throwable) {
        log.debug("Error in http endpoint", throwable);
    }
}

