/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.actions;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.client.actions.AbstractHTTPAction;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnector;
import io.ballerina.stdlib.http.transport.contract.HttpClientConnectorListener;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.concurrent.CompletableFuture;

public class GetPromisedResponse
extends AbstractHTTPAction {
    public static Object getPromisedResponse(Environment env, BObject clientObj, BObject pushPromiseObj) {
        HttpClientConnector clientConnector = (HttpClientConnector)clientObj.getNativeData("Client");
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, clientConnector, pushPromiseObj, null);
            Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, null);
            if (http2PushPromise == null) {
                throw HttpUtil.createHttpError("invalid push promise");
            }
            clientConnector.getPushResponse(http2PushPromise).setPushResponseListener(new PushResponseListener(dataContext), http2PushPromise.getPromisedStreamId());
            return ExternUtils.getResult(balFuture);
        });
    }

    private GetPromisedResponse() {
    }

    private static class PushResponseListener
    implements HttpClientConnectorListener {
        private DataContext dataContext;

        PushResponseListener(DataContext dataContext) {
            this.dataContext = dataContext;
        }

        @Override
        public void onPushResponse(int promisedId, HttpCarbonMessage httpCarbonMessage) {
            this.dataContext.notifyInboundResponseStatus(HttpUtil.createResponseStruct(httpCarbonMessage), null);
        }

        @Override
        public void onError(Throwable throwable) {
            BError httpConnectorError = HttpUtil.createHttpError(throwable.getMessage());
            this.dataContext.notifyInboundResponseStatus(null, httpConnectorError);
        }
    }
}

