/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.client.caching;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.client.caching.CacheControlDirective;
import io.ballerina.stdlib.http.api.client.caching.CacheControlParser;
import java.math.BigDecimal;
import java.util.Map;

public class RequestCacheControlObj {
    private BObject requestCacheControl;

    public RequestCacheControlObj(BObject requestCacheControl) {
        this.requestCacheControl = requestCacheControl;
        requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_NO_TRANSFORM_FIELD, (Object)true);
        requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MAX_AGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(-1L)));
        requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MAX_STALE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(-1L)));
        requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MIN_FRESH_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(-1L)));
    }

    public BObject getObj() {
        return this.requestCacheControl;
    }

    public void populateStruct(String cacheControlHeaderVal) {
        Map<CacheControlDirective, String> controlDirectives = CacheControlParser.parse(cacheControlHeaderVal);
        controlDirectives.forEach((directive, value) -> {
            switch (directive) {
                case NO_CACHE: {
                    this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_NO_CACHE_FIELD, (Object)true);
                    break;
                }
                case NO_STORE: {
                    this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_NO_STORE_FIELD, (Object)true);
                    break;
                }
                case NO_TRANSFORM: {
                    this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_NO_TRANSFORM_FIELD, (Object)true);
                    break;
                }
                case ONLY_IF_CACHED: {
                    this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_ONLY_IF_CACHED_FIELD, (Object)true);
                    break;
                }
                case MAX_AGE: {
                    try {
                        this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MAX_AGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Long.parseLong(value))));
                    }
                    catch (NumberFormatException e) {
                        this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MAX_AGE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(0L)));
                    }
                    break;
                }
                case MAX_STALE: {
                    try {
                        this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MAX_STALE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Long.parseLong(value))));
                    }
                    catch (NumberFormatException e) {
                        this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MAX_STALE_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(0L)));
                    }
                    break;
                }
                case MIN_FRESH: {
                    try {
                        this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MIN_FRESH_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(Long.parseLong(value))));
                    }
                    catch (NumberFormatException e) {
                        this.requestCacheControl.set(HttpConstants.REQ_CACHE_CONTROL_MIN_FRESH_FIELD, (Object)ValueCreator.createDecimalValue((BigDecimal)BigDecimal.valueOf(0L)));
                    }
                    break;
                }
            }
        });
    }
}

