/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl.connection;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.creators.ErrorCreator;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.DataContext;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.ExternUtils;
import io.ballerina.stdlib.http.api.nativeimpl.connection.ConnectionAction;
import io.ballerina.stdlib.http.api.nativeimpl.connection.ResponseWriter;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpMessageDataStreamer;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import java.io.OutputStream;
import java.util.concurrent.CompletableFuture;

public class PushPromisedResponse
extends ConnectionAction {
    public static Object pushPromisedResponse(Environment env, BObject connectionObj, BObject pushPromiseObj, BObject outboundResponseObj) {
        HttpCarbonMessage inboundRequestMsg = HttpUtil.getCarbonMsg(connectionObj, null);
        return env.yieldAndRun(() -> {
            CompletableFuture<Object> balFuture = new CompletableFuture<Object>();
            DataContext dataContext = new DataContext(env, balFuture, inboundRequestMsg);
            HttpUtil.serverConnectionStructCheck(inboundRequestMsg);
            Http2PushPromise http2PushPromise = HttpUtil.getPushPromise(pushPromiseObj, null);
            if (http2PushPromise == null) {
                throw ErrorCreator.createError((BString)StringUtils.fromString((String)"invalid push promise"));
            }
            HttpCarbonMessage outboundResponseMsg = HttpUtil.getCarbonMsg(outboundResponseObj, HttpUtil.createHttpCarbonMessage(false));
            HttpUtil.prepareOutboundResponse(connectionObj, inboundRequestMsg, outboundResponseMsg, outboundResponseObj);
            PushPromisedResponse.pushResponseRobust(dataContext, inboundRequestMsg, outboundResponseObj, outboundResponseMsg, http2PushPromise);
            return ExternUtils.getResult(balFuture);
        });
    }

    private static void pushResponseRobust(DataContext dataContext, HttpCarbonMessage requestMessage, BObject outboundResponseObj, HttpCarbonMessage responseMessage, Http2PushPromise http2PushPromise) {
        HttpResponseFuture outboundRespStatusFuture = HttpUtil.pushResponse(requestMessage, responseMessage, http2PushPromise);
        HttpMessageDataStreamer outboundMsgDataStreamer = PushPromisedResponse.getMessageDataStreamer(responseMessage);
        ResponseWriter.HttpResponseConnectorListener outboundResStatusConnectorListener = new ResponseWriter.HttpResponseConnectorListener(dataContext, outboundMsgDataStreamer);
        outboundRespStatusFuture.setHttpConnectorListener(outboundResStatusConnectorListener);
        OutputStream messageOutputStream = outboundMsgDataStreamer.getOutputStream();
        BObject entityObj = HttpUtil.extractEntity(outboundResponseObj);
        if (entityObj != null) {
            Object outboundMessageSource = EntityBodyHandler.getMessageDataSource((BObject)entityObj);
            PushPromisedResponse.serializeMsgDataSource(dataContext, outboundMessageSource, entityObj, messageOutputStream);
        }
    }

    private PushPromisedResponse() {
    }
}

