/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.nativeimpl.pipelining;

import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.connection.ResponseWriter;
import io.ballerina.stdlib.http.api.nativeimpl.pipelining.PipelineResponseListener;
import io.ballerina.stdlib.http.api.nativeimpl.pipelining.PipelinedResponse;
import io.ballerina.stdlib.http.transport.contract.Constants;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.ballerina.stdlib.http.transport.message.HttpPipeliningFuture;
import io.netty.channel.ChannelHandlerContext;
import java.util.Queue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PipeliningHandler {
    private static final Logger log = LoggerFactory.getLogger(PipeliningHandler.class);

    public static HttpResponseFuture sendPipelinedResponse(HttpCarbonMessage requestMsg, HttpCarbonMessage responseMsg) {
        HttpResponseFuture responseFuture;
        try {
            responseMsg.setPipeliningEnabled(requestMsg.isPipeliningEnabled());
            if (PipeliningHandler.pipeliningRequired(requestMsg)) {
                PipelinedResponse pipelinedResponse = new PipelinedResponse(requestMsg, responseMsg);
                PipeliningHandler.setPipeliningListener(responseMsg);
                responseFuture = PipeliningHandler.executePipeliningLogic(requestMsg.getSourceContext(), pipelinedResponse);
            } else {
                responseFuture = requestMsg.respond(responseMsg);
            }
        }
        catch (ServerConnectorException e) {
            throw new BallerinaConnectorException("Error occurred while sending outbound response", e);
        }
        return responseFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HttpResponseFuture executePipeliningLogic(ChannelHandlerContext sourceContext, PipelinedResponse pipelinedResponse) {
        HttpResponseFuture responseFuture = null;
        Queue queue = (Queue)sourceContext.channel().attr(Constants.RESPONSE_QUEUE).get();
        synchronized (queue) {
            Queue responseQueue = (Queue)sourceContext.channel().attr(Constants.RESPONSE_QUEUE).get();
            if (PipeliningHandler.thresholdReached(sourceContext, responseQueue)) {
                return null;
            }
            if (pipelinedResponse != null) {
                responseQueue.add(pipelinedResponse);
            }
            while (!responseQueue.isEmpty()) {
                long nextSequenceNumber = (Long)sourceContext.channel().attr(Constants.NEXT_SEQUENCE_NUMBER).get();
                PipelinedResponse queuedPipelinedResponse = (PipelinedResponse)responseQueue.peek();
                long currentSequenceNumber = queuedPipelinedResponse.getSequenceId();
                if (currentSequenceNumber != nextSequenceNumber) break;
                responseQueue.remove();
                if (queuedPipelinedResponse.getDataContext() != null && queuedPipelinedResponse.getOutboundResponseObj() != null) {
                    ResponseWriter.sendResponseRobust(queuedPipelinedResponse.getDataContext(), queuedPipelinedResponse.getInboundRequestMsg(), queuedPipelinedResponse.getOutboundResponseObj(), queuedPipelinedResponse.getOutboundResponseMsg());
                    continue;
                }
                responseFuture = HttpUtil.sendOutboundResponse(queuedPipelinedResponse.getInboundRequestMsg(), queuedPipelinedResponse.getOutboundResponseMsg());
            }
            return responseFuture;
        }
    }

    public static boolean pipeliningRequired(HttpCarbonMessage request) {
        String httpVersion = request.getHttpVersion();
        return request.isPipeliningEnabled() && request.isKeepAlive() && "1.1".equalsIgnoreCase(httpVersion);
    }

    private static boolean thresholdReached(ChannelHandlerContext sourceContext, Queue<PipelinedResponse> responseQueue) {
        long maxQueuedResponses = (Long)sourceContext.channel().attr(Constants.MAX_RESPONSES_ALLOWED_TO_BE_QUEUED).get();
        if (-1L == maxQueuedResponses) {
            return false;
        }
        if ((long)responseQueue.size() > maxQueuedResponses) {
            sourceContext.channel().close();
            log.warn("Threshold {} for pipelined response queue reached hence closing the connection.", (Object)maxQueuedResponses);
            return true;
        }
        return false;
    }

    public static void setPipeliningListener(HttpCarbonMessage httpResponse) {
        PipelineResponseListener pipeliningListener = new PipelineResponseListener();
        HttpPipeliningFuture pipeliningFuture = new HttpPipeliningFuture();
        pipeliningFuture.setPipeliningListener(pipeliningListener);
        httpResponse.setPipeliningFuture(pipeliningFuture);
    }

    private PipeliningHandler() {
    }
}

