/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpResourceArguments;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.service.signature.ParamUtils;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import io.ballerina.stdlib.http.api.service.signature.PathParam;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public class AllPathParams
implements Parameter {
    private final List<PathParam> allPathParams = new ArrayList<PathParam>();

    @Override
    public String getTypeName() {
        return "path";
    }

    public void add(PathParam pathParam) {
        this.allPathParams.add(pathParam);
    }

    public boolean isNotEmpty() {
        return !this.allPathParams.isEmpty();
    }

    public void populateFeed(Object[] paramFeed, HttpCarbonMessage httpCarbonMessage, Resource resource) {
        if (this.allPathParams.isEmpty()) {
            return;
        }
        HttpResourceArguments resourceArgumentValues = (HttpResourceArguments)httpCarbonMessage.getProperty("RESOURCE_ARGS");
        AllPathParams.updateWildcardToken(resource.getWildcardToken(), this.allPathParams.size() - 1, resourceArgumentValues.getMap());
        for (PathParam pathParam : this.allPathParams) {
            Object castedPathValue;
            String paramToken = pathParam.getToken();
            Type paramType = pathParam.getOriginalType();
            int paramTypeTag = pathParam.getEffectiveTypeTag();
            int index = pathParam.getIndex();
            String argumentValue = resourceArgumentValues.getMap().get(paramToken).get(index);
            if (argumentValue.endsWith("%")) {
                argumentValue = argumentValue.replaceAll("%", "%25");
            }
            try {
                Object parsedValue;
                if (pathParam.isArray()) {
                    String[] segments = (String[])Stream.of(argumentValue.substring(1).split("/")).map(AllPathParams::decodePathSegment).toArray(String[]::new);
                    parsedValue = ParamUtils.castParamArray(paramTypeTag, segments);
                } else {
                    parsedValue = ParamUtils.castParam(paramTypeTag, AllPathParams.decodePathSegment(argumentValue));
                }
                castedPathValue = ValueUtils.convert((Object)parsedValue, (Type)paramType);
            }
            catch (Exception ex) {
                String message = "error in casting path parameter : '" + paramToken + "'";
                if (ParamUtils.isFiniteType(paramType)) {
                    message = "no matching resource found for path : " + String.valueOf(httpCarbonMessage.getProperty("TO")) + " , method : " + httpCarbonMessage.getHttpMethod();
                    throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_RESOURCE_NOT_FOUND_ERROR, message);
                }
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_PATH_PARAM_BINDING_ERROR, message, null, HttpUtil.createError(ex));
            }
            paramFeed[index] = pathParam.validateConstraints(castedPathValue);
        }
    }

    private static String decodePathSegment(String pathSegment) {
        return URLDecoder.decode(pathSegment.replaceAll("\\+", "%2B"), StandardCharsets.UTF_8);
    }

    private static void updateWildcardToken(String wildcardToken, int wildCardIndex, Map<String, Map<Integer, String>> arguments) {
        if (wildcardToken == null) {
            return;
        }
        String wildcardPathSegment = arguments.get("EXTRA_PATH_INFO").get(HttpConstants.EXTRA_PATH_INDEX);
        if (arguments.containsKey(wildcardToken)) {
            Map<Integer, String> indexValueMap = arguments.get(wildcardToken);
            indexValueMap.put(wildCardIndex, wildcardPathSegment);
        } else {
            arguments.put(wildcardToken, Collections.singletonMap(wildCardIndex, wildcardPathSegment));
        }
    }
}

