/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.RecordType;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.stdlib.http.api.service.signature.HeaderParam;
import io.ballerina.stdlib.http.api.service.signature.ParamUtils;
import java.util.List;

public class HeaderRecordParam
extends HeaderParam {
    private final List<String> keys;
    private final FieldParam[] fields;
    private final Type type;

    public HeaderRecordParam(String token, Type type, List<String> keys, FieldParam[] fields) {
        super(token);
        this.type = type;
        this.keys = keys;
        this.fields = (FieldParam[])fields.clone();
    }

    public RecordType getOriginalType() {
        return (RecordType)this.type;
    }

    public List<String> getKeys() {
        return this.keys;
    }

    public FieldParam getField(int index) {
        return this.fields[index];
    }

    static class FieldParam {
        private final boolean nilable;
        private final int effectiveTypeTag;
        private final boolean isArray;

        public FieldParam(Type fieldType) {
            this.nilable = fieldType.isNilable();
            this.effectiveTypeTag = ParamUtils.getEffectiveTypeTag(fieldType, fieldType, "header");
            this.isArray = ParamUtils.isArrayType(fieldType);
        }

        public boolean isNilable() {
            return this.nilable;
        }

        public int getEffectiveTypeTag() {
            return this.effectiveTypeTag;
        }

        public boolean isArray() {
            return this.isArray;
        }
    }
}

