/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.stdlib.constraint.Constraints;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.SignatureParam;

public class PathParam
extends SignatureParam {
    PathParam(Type originalType, String token, int index, boolean requireConstraintValidation) {
        super(originalType, token, index, requireConstraintValidation, "path");
    }

    @Override
    public Object validateConstraints(Object pathValue) {
        Object result;
        if (this.requireConstraintValidation() && (result = Constraints.validateAfterTypeConversion((Object)pathValue, (Type)this.getOriginalType())) instanceof BError) {
            String message = "path validation failed: " + HttpUtil.getPrintableErrorMsg((BError)((Object)result));
            throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_QUERY_PARAM_VALIDATION_ERROR, message);
        }
        return pathValue;
    }
}

