/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.stdlib.http.api.service.signature.ParamUtils;

public abstract class SignatureParam {
    private final String token;
    private int index;
    private Type originalType;
    private int effectiveTypeTag;
    private boolean isArray;
    private boolean requireConstraintValidation;

    public SignatureParam(String token) {
        this.token = token;
    }

    public SignatureParam(Type originalType, String token, int index, boolean requireConstraintValidation, String paramType) {
        this.originalType = originalType;
        this.token = token;
        this.index = index;
        this.effectiveTypeTag = ParamUtils.getEffectiveTypeTag(originalType, originalType, paramType);
        this.isArray = ParamUtils.isArrayType(originalType);
        this.requireConstraintValidation = requireConstraintValidation;
    }

    public void init(Type originalType, int index, boolean requireConstraintValidation) {
        this.originalType = originalType;
        this.index = index;
        this.requireConstraintValidation = requireConstraintValidation;
    }

    public String getToken() {
        return this.token;
    }

    public int getIndex() {
        return this.index;
    }

    public Type getOriginalType() {
        return this.originalType;
    }

    public void setEffectiveTypeTag(int effectiveTypeTag) {
        this.effectiveTypeTag = effectiveTypeTag;
    }

    public int getEffectiveTypeTag() {
        return this.effectiveTypeTag;
    }

    public void setArray(boolean array) {
        this.isArray = array;
    }

    public boolean isArray() {
        return this.isArray;
    }

    public boolean requireConstraintValidation() {
        return this.requireConstraintValidation;
    }

    public abstract Object validateConstraints(Object var1);
}

