/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.builder;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.stdlib.http.api.service.signature.builder.AbstractPayloadBuilder;
import io.ballerina.stdlib.http.api.service.signature.converter.JsonToRecordConverter;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;

public class JsonPayloadBuilder
extends AbstractPayloadBuilder {
    private final Type payloadType;
    private final boolean laxDataBinding;

    public JsonPayloadBuilder(Type payloadType, boolean laxDataBinding) {
        this.payloadType = payloadType;
        this.laxDataBinding = laxDataBinding;
    }

    @Override
    public Object getValue(BObject entity, boolean readonly) {
        if (JsonPayloadBuilder.isSubtypeOfAllowedType(this.payloadType, 24)) {
            return JsonToRecordConverter.convert(this.payloadType, entity, readonly, this.laxDataBinding);
        }
        Object bJson = EntityBodyHandler.constructJsonDataSource((BObject)entity);
        EntityBodyHandler.addJsonMessageDataSource((BObject)entity, (Object)bJson);
        Object result = ValueUtils.convert((Object)bJson, (Type)this.payloadType);
        if (readonly && result instanceof BRefValue) {
            ((BRefValue)result).freezeDirect();
        }
        return result;
    }
}

