/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature.converter;

import io.ballerina.lib.data.ModuleUtils;
import io.ballerina.lib.data.jsondata.json.Native;
import io.ballerina.runtime.api.Module;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.runtime.api.values.BRefValue;
import io.ballerina.runtime.api.values.BTypedesc;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HttpConstants;
import io.ballerina.stdlib.mime.util.EntityBodyHandler;
import java.util.HashMap;

public class JsonToRecordConverter {
    public static Object convert(Type type, BObject entity, boolean readonly, boolean laxDataBinding) {
        Object recordEntity = JsonToRecordConverter.getRecordEntity(entity, type, laxDataBinding);
        if (readonly && recordEntity instanceof BRefValue) {
            ((BRefValue)recordEntity).freezeDirect();
        }
        return recordEntity;
    }

    private static Object getRecordEntity(BObject entity, Type entityBodyType, boolean laxDataBinding) {
        Object bjson = EntityBodyHandler.getMessageDataSource((BObject)entity) == null ? JsonToRecordConverter.getBJsonValue(entity) : EntityBodyHandler.getMessageDataSource((BObject)entity);
        Object result = JsonToRecordConverter.getRecord(entityBodyType, bjson, laxDataBinding);
        if (result instanceof BError) {
            throw (BError)((Object)result);
        }
        return result;
    }

    private static Object getRecord(Type entityBodyType, Object bJson, boolean laxDataBinding) {
        try {
            HashMap<String, Boolean> valueMap = new HashMap<String, Boolean>();
            valueMap.put("enableConstraintValidation", Boolean.FALSE);
            BMap mapValue = ValueCreator.createRecordValue((Module)ModuleUtils.getModule(), (String)"Options", valueMap);
            if (laxDataBinding) {
                BMap allowDataProjection = mapValue.getMapValue(HttpConstants.ALLOW_DATA_PROJECTION);
                allowDataProjection.put((Object)HttpConstants.NIL_AS_OPTIONAL, (Object)Boolean.TRUE);
                allowDataProjection.put((Object)HttpConstants.ABSENT_AS_NILABLE, (Object)Boolean.TRUE);
            } else {
                mapValue.put((Object)HttpConstants.ALLOW_DATA_PROJECTION, (Object)Boolean.FALSE);
            }
            BTypedesc typedescValue = ValueCreator.createTypedescValue((Type)entityBodyType);
            return Native.parseAsType((Object)bJson, (BMap)mapValue, (BTypedesc)typedescValue);
        }
        catch (NullPointerException ex) {
            throw new BallerinaConnectorException("cannot convert payload to record type: " + entityBodyType.getName());
        }
    }

    private static Object getBJsonValue(BObject entity) {
        Object bjson = EntityBodyHandler.constructJsonDataSource((BObject)entity);
        EntityBodyHandler.addJsonMessageDataSource((BObject)entity, (Object)bjson);
        return bjson;
    }

    private JsonToRecordConverter() {
    }
}

