/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contract.config;

import io.ballerina.stdlib.http.transport.contract.config.Parameter;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.ssl.SSLConfig;
import io.netty.handler.ssl.SslContext;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SslConfiguration {
    private String scheme = "http";
    private List<Parameter> parameters = new ArrayList<Parameter>();
    private SSLConfig sslConfig = new SSLConfig();
    private static final Logger LOG = LoggerFactory.getLogger(SslConfiguration.class);

    public void setKeyStoreFile(String keyStoreFile) {
        this.sslConfig.setKeyStore(new File(Util.substituteVariables(keyStoreFile)));
    }

    public void setKeyStorePass(String keyStorePassword) {
        this.sslConfig.setKeyStorePass(keyStorePassword);
    }

    public void setVerifyClient(String verifyClient) {
        if ("require".equalsIgnoreCase(verifyClient)) {
            this.sslConfig.setNeedClientAuth(true);
        } else if ("optional".equalsIgnoreCase(verifyClient)) {
            this.sslConfig.setWantClientAuth(true);
        } else if (!verifyClient.isEmpty()) {
            LOG.warn("Received an unidentified configuration for sslVerify client. Hence client verification will be disabled which is the default configuration.");
        }
    }

    public String getScheme() {
        return this.scheme;
    }

    public void setScheme(String scheme) {
        this.scheme = scheme;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.sslConfig.setTrustStore(new File(Util.substituteVariables(trustStoreFile)));
    }

    public void setTrustStorePass(String trustStorePass) {
        this.sslConfig.setTrustStorePass(trustStorePass);
    }

    public void setSSLProtocol(String sslProtocol) {
        this.sslConfig.setSSLProtocol(sslProtocol);
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public void setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
    }

    public void setTLSStoreType(String tlsStoreType) {
        this.sslConfig.setTLSStoreType(tlsStoreType);
    }

    public void setValidateCertEnabled(boolean validateCertEnabled) {
        this.sslConfig.setValidateCertEnabled(validateCertEnabled);
    }

    public void setHostNameVerificationEnabled(boolean hostNameVerificationEnabled) {
        this.sslConfig.setHostNameVerificationEnabled(hostNameVerificationEnabled);
    }

    public void setCacheValidityPeriod(int cacheValidityPeriod) {
        this.sslConfig.setCacheValidityPeriod(cacheValidityPeriod);
    }

    public void setCacheSize(int cacheSize) {
        this.sslConfig.setCacheSize(cacheSize);
    }

    public void setOcspStaplingEnabled(boolean ocspStaplingEnabled) {
        this.sslConfig.setOcspStaplingEnabled(ocspStaplingEnabled);
    }

    public String getKeyStoreFile() {
        return String.valueOf(this.sslConfig.getKeyStore());
    }

    public String getKeyStorePass() {
        return this.sslConfig.getKeyStorePass();
    }

    public void setServerKeyFile(String serverKeyFile) {
        this.sslConfig.setServerKeyFile(new File(Util.substituteVariables(serverKeyFile)));
    }

    public void setServerCertificates(String serverCertificates) {
        this.sslConfig.setServerCertificates(new File(Util.substituteVariables(serverCertificates)));
    }

    public void setClientKeyFile(String clientKeyFile) {
        this.sslConfig.setClientKeyFile(new File(Util.substituteVariables(clientKeyFile)));
    }

    public void setClientCertificates(String clientCertificates) {
        this.sslConfig.setClientCertificates(new File(Util.substituteVariables(clientCertificates)));
    }

    public void setServerTrustCertificates(String serverTrustCertificates) {
        this.sslConfig.setServerTrustCertificates(new File(Util.substituteVariables(serverTrustCertificates)));
    }

    public void setClientTrustCertificates(String clientTrustCertificates) {
        this.sslConfig.setClientTrustCertificates(new File(Util.substituteVariables(clientTrustCertificates)));
    }

    public void setClientKeyPassword(String clientKeyPassword) {
        this.sslConfig.setClientKeyPassword(clientKeyPassword);
    }

    public void setServerKeyPassword(String serverKeyPassword) {
        this.sslConfig.setServerKeyPassword(serverKeyPassword);
    }

    public void setSslSessionTimeOut(int sessionTimeOut) {
        this.sslConfig.setSessionTimeOut(sessionTimeOut);
    }

    public void setSslHandshakeTimeOut(long handshakeTimeOut) {
        this.sslConfig.setHandshakeTimeOut(handshakeTimeOut);
    }

    public void setSslContext(SslContext sslContext) {
        this.sslConfig.setSslContext(sslContext);
    }

    public void disableSsl() {
        this.sslConfig.disableSsl();
    }

    public void useJavaDefaults() {
        this.sslConfig.setUseJavaDefaults();
    }

    public SSLConfig getClientSSLConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return this.getSSLConfigForSender();
    }

    public SSLConfig getListenerSSLConfig() {
        if (this.scheme == null || !this.scheme.equalsIgnoreCase("https")) {
            return null;
        }
        return this.getSSLConfigForListener();
    }

    private SSLConfig getSSLConfigForListener() {
        if (!(this.sslConfig.getKeyStore() != null && this.sslConfig.getKeyStorePass() != null || this.sslConfig.getServerKeyFile() != null && this.sslConfig.getServerCertificates() != null)) {
            throw new IllegalArgumentException("keyStoreFile or keyStorePassword not defined for HTTPS scheme");
        }
        if (this.sslConfig.getKeyStore() != null) {
            if (!this.sslConfig.getKeyStore().exists()) {
                throw new IllegalArgumentException("KeyStore File " + String.valueOf(this.sslConfig.getKeyStore()) + " not found");
            }
            this.sslConfig.setCertPass(this.sslConfig.getKeyStorePass());
        } else if (!this.sslConfig.getServerKeyFile().exists() || !this.sslConfig.getServerCertificates().exists()) {
            throw new IllegalArgumentException("Key file or server certificates file not found");
        }
        for (Parameter parameter : this.parameters) {
            switch (parameter.getName()) {
                case "ciphers": {
                    this.sslConfig.setCipherSuites(parameter.getValue());
                    break;
                }
                case "sslEnabledProtocols": {
                    this.sslConfig.setEnableProtocols(parameter.getValue());
                    break;
                }
                case "server.supported.snimatchers": {
                    this.sslConfig.setSniMatchers(parameter.getValue());
                    break;
                }
                case "server.suported.server.names": {
                    this.sslConfig.setServerNames(parameter.getValue());
                    break;
                }
                case "shareSession": {
                    this.sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
                    break;
                }
            }
        }
        String sslProtocol = this.sslConfig.getSSLProtocol() != null ? this.sslConfig.getSSLProtocol() : "TLS";
        this.sslConfig.setSSLProtocol(sslProtocol);
        String tlsStoreType = this.sslConfig.getTLSStoreType() != null ? this.sslConfig.getTLSStoreType() : "JKS";
        this.sslConfig.setTLSStoreType(tlsStoreType);
        if (this.sslConfig.getTrustStore() != null) {
            if (!this.sslConfig.getTrustStore().exists()) {
                throw new IllegalArgumentException("TrustStore file " + String.valueOf(this.sslConfig.getTrustStore()) + " not found");
            }
            if (this.sslConfig.getTrustStorePass() == null) {
                throw new IllegalArgumentException("Truststore password is not defined for HTTPS scheme");
            }
        }
        return this.sslConfig;
    }

    private SSLConfig getSSLConfigForSender() {
        this.setSslParameters();
        if (this.sslConfig.isDisableSsl() || this.sslConfig.useJavaDefaults()) {
            return this.sslConfig;
        }
        if ((this.sslConfig.getTrustStore() == null || this.sslConfig.getTrustStorePass() == null) && this.sslConfig.getClientTrustCertificates() == null) {
            throw new IllegalArgumentException("TrustStoreFile or TrustStorePassword not defined for HTTPS/WS scheme");
        }
        if (this.sslConfig.getTrustStore() != null) {
            if (!this.sslConfig.getTrustStore().exists()) {
                throw new IllegalArgumentException("TrustStore File " + String.valueOf(this.sslConfig.getTrustStore()) + " not found");
            }
            this.sslConfig.setCertPass(this.sslConfig.getKeyStorePass());
        } else if (!this.sslConfig.getClientTrustCertificates().exists()) {
            throw new IllegalArgumentException("Key file or server certificates file not found");
        }
        this.sslConfig.setTrustStore(this.sslConfig.getTrustStore()).setTrustStorePass(this.sslConfig.getTrustStorePass());
        String sslProtocol = this.sslConfig.getSSLProtocol() != null ? this.sslConfig.getSSLProtocol() : "TLS";
        this.sslConfig.setSSLProtocol(sslProtocol);
        String tlsStoreType = this.sslConfig.getTLSStoreType() != null ? this.sslConfig.getTLSStoreType() : "JKS";
        this.sslConfig.setTLSStoreType(tlsStoreType);
        return this.sslConfig;
    }

    private void setSslParameters() {
        if (this.parameters != null) {
            for (Parameter parameter : this.parameters) {
                switch (parameter.getName()) {
                    case "ciphers": {
                        this.sslConfig.setCipherSuites(parameter.getValue());
                        break;
                    }
                    case "sslEnabledProtocols": {
                        this.sslConfig.setEnableProtocols(parameter.getValue());
                        break;
                    }
                    case "shareSession": {
                        this.sslConfig.setEnableSessionCreation(Boolean.parseBoolean(parameter.getValue()));
                        break;
                    }
                    case "serverName": {
                        this.sslConfig.setSniHostName(parameter.getValue());
                        break;
                    }
                }
            }
        }
    }
}

