/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.ocsp;

import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.CertificateVerificationException;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.RevocationStatus;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.RevocationVerifier;
import io.ballerina.stdlib.http.transport.contractimpl.common.certificatevalidation.ocsp.OCSPCache;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.net.HttpURLConnection;
import java.net.URL;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import org.bouncycastle.asn1.ASN1IA5String;
import org.bouncycastle.asn1.ASN1InputStream;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.ocsp.OCSPObjectIdentifiers;
import org.bouncycastle.asn1.x509.AccessDescription;
import org.bouncycastle.asn1.x509.AuthorityInformationAccess;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.GeneralName;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.ocsp.BasicOCSPResp;
import org.bouncycastle.cert.ocsp.CertificateID;
import org.bouncycastle.cert.ocsp.CertificateStatus;
import org.bouncycastle.cert.ocsp.OCSPException;
import org.bouncycastle.cert.ocsp.OCSPReq;
import org.bouncycastle.cert.ocsp.OCSPReqBuilder;
import org.bouncycastle.cert.ocsp.OCSPResp;
import org.bouncycastle.cert.ocsp.RevokedStatus;
import org.bouncycastle.cert.ocsp.SingleResp;
import org.bouncycastle.cert.ocsp.UnknownStatus;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.operator.DigestCalculatorProvider;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.jcajce.JcaDigestCalculatorProviderBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OCSPVerifier
implements RevocationVerifier {
    private OCSPCache cache;
    private static final Logger LOG = LoggerFactory.getLogger(OCSPVerifier.class);

    public OCSPVerifier(OCSPCache cache) {
        this.cache = cache;
    }

    @Override
    public RevocationStatus checkRevocationStatus(X509Certificate peerCert, X509Certificate issuerCert) throws CertificateVerificationException {
        SingleResp resp;
        if (this.cache != null && (resp = this.cache.getCacheValue(peerCert.getSerialNumber())) != null) {
            RevocationStatus status = this.getRevocationStatus(resp);
            if (LOG.isInfoEnabled()) {
                LOG.info("OCSP response taken from cache.");
            }
            return status;
        }
        OCSPReq request = OCSPVerifier.generateOCSPRequest(issuerCert, peerCert.getSerialNumber());
        List<String> locations = OCSPVerifier.getAIALocations(peerCert);
        OCSPResp ocspResponse = null;
        for (String serviceUrl : locations) {
            SingleResp[] responses;
            try {
                ocspResponse = OCSPVerifier.getOCSPResponce(serviceUrl, request);
                if (0 != ocspResponse.getStatus()) continue;
                BasicOCSPResp basicResponse = (BasicOCSPResp)ocspResponse.getResponseObject();
                responses = basicResponse == null ? null : basicResponse.getResponses();
            }
            catch (Exception e) {
                continue;
            }
            if (responses == null || responses.length != 1) continue;
            SingleResp resp2 = responses[0];
            RevocationStatus status = this.getRevocationStatus(resp2);
            if (this.cache != null) {
                this.cache.setCacheValue(ocspResponse, peerCert.getSerialNumber(), resp2, request, serviceUrl);
            }
            return status;
        }
        throw new CertificateVerificationException("Could not get revocation status from OCSP.");
    }

    private RevocationStatus getRevocationStatus(SingleResp resp) throws CertificateVerificationException {
        CertificateStatus status = resp.getCertStatus();
        if (status == CertificateStatus.GOOD) {
            return RevocationStatus.GOOD;
        }
        if (status instanceof RevokedStatus) {
            return RevocationStatus.REVOKED;
        }
        if (status instanceof UnknownStatus) {
            return RevocationStatus.UNKNOWN;
        }
        throw new CertificateVerificationException("Could not recognize OCSP certificate status for :" + String.valueOf(status));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static OCSPResp getOCSPResponce(String serviceUrl, OCSPReq request) throws CertificateVerificationException {
        try {
            byte[] array = request.getEncoded();
            if (serviceUrl.startsWith("http")) {
                URL url = new URL(serviceUrl);
                HttpURLConnection connection = (HttpURLConnection)url.openConnection();
                connection.setRequestProperty("Content-Type", "application/ocsp-request");
                connection.setRequestProperty("Accept", "application/ocsp-response");
                connection.setDoOutput(true);
                try (OutputStream out = connection.getOutputStream();){
                    OCSPResp oCSPResp;
                    try (DataOutputStream dataOut = new DataOutputStream(new BufferedOutputStream(out));){
                        dataOut.write(array);
                        dataOut.flush();
                        if (connection.getResponseCode() / 100 != 2) {
                            throw new CertificateVerificationException("Error getting ocsp response.Response code is " + connection.getResponseCode());
                        }
                        InputStream in = (InputStream)connection.getContent();
                        oCSPResp = new OCSPResp(in);
                    }
                    return oCSPResp;
                }
            }
            throw new CertificateVerificationException("Only http is supported for OCSP calls");
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot get OCSP Response from url: " + serviceUrl, e);
        }
    }

    public static OCSPReq generateOCSPRequest(X509Certificate issuerCert, BigInteger serialNumber) throws CertificateVerificationException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        try {
            byte[] issuerCertEnc = issuerCert.getEncoded();
            X509CertificateHolder certificateHolder = new X509CertificateHolder(issuerCertEnc);
            DigestCalculatorProvider digCalcProv = new JcaDigestCalculatorProviderBuilder().setProvider("BC").build();
            CertificateID id = new CertificateID(digCalcProv.get(CertificateID.HASH_SHA1), certificateHolder, serialNumber);
            OCSPReqBuilder builder = new OCSPReqBuilder();
            builder.addRequest(id);
            BigInteger nonce = BigInteger.valueOf(System.currentTimeMillis());
            builder.setRequestExtensions(new Extensions(new Extension(OCSPObjectIdentifiers.id_pkix_ocsp_nonce, false, (ASN1OctetString)new DEROctetString(nonce.toByteArray()))));
            return builder.build();
        }
        catch (IOException | CertificateEncodingException | OCSPException | OperatorCreationException e) {
            throw new CertificateVerificationException("Cannot generate OCSP Request with the given certificate", e);
        }
    }

    public static List<String> getAIALocations(X509Certificate cert) throws CertificateVerificationException {
        AccessDescription[] accessDescriptions;
        AuthorityInformationAccess authorityInformationAccess;
        byte[] aiaExtensionValue = cert.getExtensionValue(Extension.authorityInfoAccess.getId());
        if (aiaExtensionValue == null) {
            throw new CertificateVerificationException("Certificate doesn't have Authority Information Access points");
        }
        ASN1InputStream asn1InputStream = null;
        try {
            DEROctetString oct = (DEROctetString)new ASN1InputStream((InputStream)new ByteArrayInputStream(aiaExtensionValue)).readObject();
            asn1InputStream = new ASN1InputStream(oct.getOctets());
            authorityInformationAccess = AuthorityInformationAccess.getInstance((Object)asn1InputStream.readObject());
        }
        catch (IOException e) {
            throw new CertificateVerificationException("Cannot read certificate to get OSCP urls", e);
        }
        finally {
            try {
                if (asn1InputStream != null) {
                    asn1InputStream.close();
                }
            }
            catch (IOException e) {
                LOG.error("Cannot close ASN1InputStream", (Throwable)e);
            }
        }
        ArrayList<String> ocspUrlList = new ArrayList<String>();
        for (AccessDescription accessDescription : accessDescriptions = authorityInformationAccess.getAccessDescriptions()) {
            GeneralName gn = accessDescription.getAccessLocation();
            if (gn.getTagNo() != 6) continue;
            ASN1IA5String str = ASN1IA5String.getInstance((Object)gn.getName());
            String accessLocation = str.getString();
            ocspUrlList.add(accessLocation);
        }
        if (ocspUrlList.isEmpty()) {
            throw new CertificateVerificationException("Cannot get OCSP urls from certificate");
        }
        return ocspUrlList;
    }
}

