/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states;

import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.HttpOutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.Expect100ContinueHeaderReceived;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerReqRespStateManager;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ReceivingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.ResponseCompleted;
import io.ballerina.stdlib.http.transport.internal.HandlerExecutor;
import io.ballerina.stdlib.http.transport.internal.HttpTransportContextHolder;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingHeaders
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingHeaders.class);
    private final SourceHandler sourceHandler;
    private final HandlerExecutor handlerExecutor;
    private final ListenerReqRespStateManager listenerReqRespStateManager;
    private HttpCarbonMessage inboundRequestMsg;
    private float httpVersion;

    public ReceivingHeaders(ListenerReqRespStateManager listenerReqRespStateManager, SourceHandler sourceHandler) {
        this.listenerReqRespStateManager = listenerReqRespStateManager;
        this.sourceHandler = sourceHandler;
        this.handlerExecutor = HttpTransportContextHolder.getInstance().getHandlerExecutor();
    }

    @Override
    public void readInboundRequestHeaders(HttpCarbonMessage inboundRequestMsg, HttpRequest inboundRequestHeaders) {
        this.inboundRequestMsg = inboundRequestMsg;
        this.httpVersion = Float.parseFloat(inboundRequestMsg.getHttpVersion());
        boolean continueRequest = Util.is100ContinueRequest(inboundRequestMsg);
        if (continueRequest) {
            this.listenerReqRespStateManager.state = new Expect100ContinueHeaderReceived(this.listenerReqRespStateManager, this.sourceHandler, inboundRequestMsg, this.httpVersion);
        }
        this.notifyRequestListener(inboundRequestMsg);
        if (inboundRequestHeaders.decoderResult().isFailure()) {
            LOG.debug(inboundRequestHeaders.decoderResult().cause().getMessage());
        }
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(inboundRequestMsg);
        }
    }

    private void notifyRequestListener(HttpCarbonMessage httpRequestMsg) {
        if (this.handlerExecutor != null) {
            this.handlerExecutor.executeAtSourceRequestReceiving(httpRequestMsg);
        }
        if (this.sourceHandler.getServerConnectorFuture() != null) {
            try {
                ServerConnectorFuture outboundRespFuture = httpRequestMsg.getHttpResponseFuture();
                outboundRespFuture.setHttpConnectorListener(new HttpOutboundRespListener(httpRequestMsg, this.sourceHandler));
                httpRequestMsg.setSourceContext(this.sourceHandler.getInboundChannelContext());
                this.sourceHandler.getServerConnectorFuture().notifyHttpListener(httpRequestMsg);
            }
            catch (Exception e) {
                LOG.error("Error while notifying listeners", (Throwable)e);
            }
        } else {
            LOG.error("Cannot find registered listener to forward the message");
        }
    }

    @Override
    public void readInboundRequestBody(Object inboundRequestEntityBody) throws ServerConnectorException {
        this.listenerReqRespStateManager.state = new ReceivingEntityBody(this.listenerReqRespStateManager, this.inboundRequestMsg, this.sourceHandler, this.httpVersion);
        this.listenerReqRespStateManager.readInboundRequestBody(inboundRequestEntityBody);
    }

    @Override
    public void writeOutboundResponseHeaders(HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        LOG.warn("writeOutboundResponseHeaders {}", (Object)"is not a valid action of this state");
    }

    @Override
    public void writeOutboundResponseBody(HttpOutboundRespListener outboundResponseListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent) {
        StateUtil.respondToIncompleteRequest(this.sourceHandler.getInboundChannelContext().channel(), outboundResponseListener, this.listenerReqRespStateManager, outboundResponseMsg, httpContent, "Remote client closed the connection while reading inbound request headers");
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture) {
        StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Remote client closed the connection while reading inbound request headers");
    }

    @Override
    public ChannelFuture handleIdleTimeoutConnectionClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx) {
        ChannelFuture outboundRespFuture = StateUtil.sendRequestTimeoutResponse(ctx, HttpResponseStatus.REQUEST_TIMEOUT, Unpooled.EMPTY_BUFFER, 0, this.httpVersion, this.sourceHandler.getServerName());
        outboundRespFuture.addListener((GenericFutureListener)((ChannelFutureListener)channelFuture -> {
            Throwable cause = channelFuture.cause();
            if (cause != null) {
                LOG.warn("Failed to send: {}", (Object)cause.getMessage());
            }
            ctx.close();
            StateUtil.handleIncompleteInboundMessage(this.inboundRequestMsg, "Idle timeout triggered while reading inbound request headers");
        }));
        this.listenerReqRespStateManager.state = new ResponseCompleted(this.listenerReqRespStateManager, this.sourceHandler, this.inboundRequestMsg);
        return outboundRespFuture;
    }
}

