/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender;

import io.ballerina.stdlib.http.transport.contract.exceptions.ClientConnectorException;
import io.ballerina.stdlib.http.transport.contract.exceptions.ConnectionTimedOutException;
import io.ballerina.stdlib.http.transport.contract.exceptions.InvalidProtocolException;
import io.ballerina.stdlib.http.transport.contract.exceptions.RequestCancelledException;
import io.ballerina.stdlib.http.transport.contract.exceptions.SslException;
import io.ballerina.stdlib.http.transport.contract.exceptions.UnresolvedHostException;
import io.ballerina.stdlib.http.transport.contractimpl.sender.ConnectionAvailabilityListener;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelPipelineException;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.UnknownHostException;
import java.nio.channels.ClosedChannelException;

public class ConnectionAvailabilityFuture {
    private ChannelFuture socketAvailabilityFuture;
    private boolean isSSLEnabled = false;
    private ConnectionAvailabilityListener listener = null;
    private String protocol;
    private boolean socketAvailable = false;
    private boolean isFailure;
    private Throwable throwable;
    private boolean forceHttp2 = false;
    private String remoteAddress;

    public void setSocketAvailabilityFuture(ChannelFuture socketAvailabilityFuture, String remoteAddress) {
        this.socketAvailabilityFuture = socketAvailabilityFuture;
        this.remoteAddress = remoteAddress;
        socketAvailabilityFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

            public void operationComplete(ChannelFuture channelFuture) throws Exception {
                if (this.isValidChannel(channelFuture)) {
                    ConnectionAvailabilityFuture.this.socketAvailable = true;
                    if (ConnectionAvailabilityFuture.this.listener != null && !ConnectionAvailabilityFuture.this.isSSLEnabled) {
                        if (ConnectionAvailabilityFuture.this.forceHttp2) {
                            ConnectionAvailabilityFuture.this.notifySuccess("h2c");
                        } else {
                            ConnectionAvailabilityFuture.this.notifySuccess("h1c");
                        }
                    }
                } else {
                    ConnectionAvailabilityFuture.this.notifyFailure(channelFuture.cause());
                }
            }

            private boolean isValidChannel(ChannelFuture channelFuture) {
                return channelFuture.isDone() && channelFuture.isSuccess();
            }
        });
    }

    void setSSLEnabled(boolean sslEnabled) {
        this.isSSLEnabled = sslEnabled;
    }

    public void setForceHttp2(boolean forceHttp2) {
        this.forceHttp2 = forceHttp2;
    }

    void notifySuccess(String protocol) {
        this.protocol = protocol;
        if (this.listener != null) {
            if (this.forceHttp2 && !protocol.equalsIgnoreCase("h2c") && !protocol.equalsIgnoreCase("h2")) {
                InvalidProtocolException connectorException = new InvalidProtocolException("Protocol must be HTTP/2", HttpResponseStatus.HTTP_VERSION_NOT_SUPPORTED.code());
                this.listener.onFailure(connectorException);
            } else {
                this.listener.onSuccess(protocol, this.socketAvailabilityFuture);
            }
        }
    }

    void notifyFailure(Throwable cause) {
        this.isFailure = true;
        this.throwable = cause;
        if (this.listener != null) {
            this.notifyErrorState(this.socketAvailabilityFuture, cause);
        }
    }

    public void setListener(ConnectionAvailabilityListener listener) {
        this.listener = listener;
        if (this.protocol != null) {
            this.notifySuccess(this.protocol);
        } else if (!this.isSSLEnabled && this.socketAvailable) {
            if (this.forceHttp2) {
                this.notifySuccess("h2c");
            } else {
                this.notifySuccess("h1c");
            }
        } else if (this.isFailure) {
            this.notifyFailure(this.throwable);
        }
    }

    private void notifyErrorState(ChannelFuture channelFuture, Throwable cause) {
        ClientConnectorException connectorException = this.createSpecificExceptionFromGeneric(channelFuture, cause, this.remoteAddress);
        this.listener.onFailure(connectorException);
    }

    private ClientConnectorException createSpecificExceptionFromGeneric(ChannelFuture channelFuture, Throwable cause, String socketAddress) {
        ClientConnectorException connectorException = this.isRequestCancelled(channelFuture) ? new RequestCancelledException("Request cancelled: " + socketAddress, HttpResponseStatus.BAD_GATEWAY.code()) : (cause instanceof ChannelPipelineException ? new ClientConnectorException("Error occurred while creating the channel pipeline: " + cause.getMessage(), HttpResponseStatus.BAD_GATEWAY.code()) : (this.isConnectionTimeout(channelFuture) ? new ConnectionTimedOutException("Connection timeout: " + socketAddress, HttpResponseStatus.BAD_GATEWAY.code()) : (this.isSslException(cause) ? new SslException("SSL connection failed:" + cause.getMessage() + " " + socketAddress, HttpResponseStatus.BAD_GATEWAY.code()) : (cause instanceof UnknownHostException ? new UnresolvedHostException("Could not resolve host:" + cause.getMessage(), HttpResponseStatus.BAD_GATEWAY.code()) : (cause instanceof ClosedChannelException ? new ClientConnectorException("Remote host: " + socketAddress + " closed the connection while SSL handshake", HttpResponseStatus.BAD_GATEWAY.code()) : this.handleInGenericWay(channelFuture))))));
        if (channelFuture.cause() != null) {
            connectorException.initCause(channelFuture.cause());
        }
        return connectorException;
    }

    private boolean isRequestCancelled(ChannelFuture channelFuture) {
        return channelFuture.isDone() && channelFuture.isCancelled();
    }

    private ClientConnectorException handleInGenericWay(ChannelFuture channelFuture) {
        ClientConnectorException connectorException = channelFuture.cause() != null ? new ClientConnectorException(channelFuture.cause().getMessage(), HttpResponseStatus.BAD_GATEWAY.code()) : new ClientConnectorException("Generic client error", HttpResponseStatus.BAD_GATEWAY.code());
        return connectorException;
    }

    private boolean isSslException(Throwable cause) {
        return cause.toString().contains("ssl") || cause.toString().contains("security");
    }

    private boolean isConnectionTimeout(ChannelFuture channelFuture) {
        return !channelFuture.isDone() && !channelFuture.isSuccess() && !channelFuture.isCancelled() && channelFuture.cause() == null;
    }
}

